/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guicier;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;

public abstract class DropwizardAwareModule<C extends Configuration>
implements Module {
    private volatile Bootstrap<?> bootstrap = null;
    private volatile C configuration = null;
    private volatile Environment environment = null;

    protected Bootstrap<?> getBootstrap() {
        return (Bootstrap)Preconditions.checkNotNull(this.bootstrap, (Object)"bootstrap was not set!");
    }

    protected C getConfiguration() {
        return (C)((Configuration)Preconditions.checkNotNull(this.configuration, (Object)"configuration was not set!"));
    }

    protected Environment getEnvironment() {
        return (Environment)Preconditions.checkNotNull((Object)this.environment, (Object)"environment was not set!");
    }

    public void setBootstrap(Bootstrap<?> bootstrap) {
        Preconditions.checkState((this.bootstrap == null ? 1 : 0) != 0, (Object)"bootstrap was already set!");
        this.bootstrap = (Bootstrap)Preconditions.checkNotNull(bootstrap, (Object)"bootstrap is null");
    }

    public void setConfiguration(C configuration) {
        Preconditions.checkState((this.configuration == null ? 1 : 0) != 0, (Object)"configuration was already set!");
        this.configuration = (Configuration)Preconditions.checkNotNull(configuration, (Object)"configuration is null");
    }

    public void setEnvironment(Environment environment) {
        Preconditions.checkState((this.environment == null ? 1 : 0) != 0, (Object)"environment was already set!");
        this.environment = (Environment)Preconditions.checkNotNull((Object)environment, (Object)"environment is null");
    }
}

