/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dropwizard.guicier;

import com.codahale.metrics.health.HealthCheck;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Environment;
import java.lang.reflect.Type;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardModule
implements Module {
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardModule.class);
    private final Environment environment;

    public DropwizardModule(Environment environment) {
        this.environment = environment;
    }

    public void configure(Binder binder) {
        binder.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListener(){

            public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                Object obj = provision.provision();
                if (obj instanceof Managed) {
                    DropwizardModule.this.handle((Managed)obj);
                }
                if (obj instanceof Task) {
                    DropwizardModule.this.handle((Task)obj);
                }
                if (obj instanceof HealthCheck) {
                    DropwizardModule.this.handle((HealthCheck)obj);
                }
                if (obj instanceof ServerLifecycleListener) {
                    DropwizardModule.this.handle((ServerLifecycleListener)obj);
                }
            }
        }});
    }

    public void register(Injector injector) {
        this.registerResourcesAndProviders((ResourceConfig)this.environment.jersey().getResourceConfig(), injector);
    }

    private void handle(Managed managed) {
        this.environment.lifecycle().manage(managed);
        LOG.info("Added guice injected managed Object: {}", (Object)managed.getClass().getName());
    }

    private void handle(Task task) {
        this.environment.admin().addTask(task);
        LOG.info("Added guice injected Task: {}", (Object)task.getClass().getName());
    }

    private void handle(HealthCheck healthcheck) {
        this.environment.healthChecks().register(healthcheck.getClass().getSimpleName(), healthcheck);
        LOG.info("Added guice injected health check: {}", (Object)healthcheck.getClass().getName());
    }

    private void handle(ServerLifecycleListener serverLifecycleListener) {
        this.environment.lifecycle().addServerLifecycleListener(serverLifecycleListener);
        LOG.info("Added guice injected server lifecycle listener: {}", (Object)serverLifecycleListener.getClass().getName());
    }

    private void registerResourcesAndProviders(ResourceConfig config, Injector injector) {
        while (injector != null) {
            for (Key key : injector.getBindings().keySet()) {
                Type type = key.getTypeLiteral().getType();
                if (!(type instanceof Class)) continue;
                Class c = (Class)type;
                if (DropwizardModule.isProviderClass(c)) {
                    LOG.info("Registering {} as a provider class", (Object)c.getName());
                    config.register(c);
                    continue;
                }
                if (!DropwizardModule.isResourceClass(c)) continue;
                if (Resource.isAcceptable((Class)c)) {
                    LOG.info("Registering {} as a root resource class", (Object)c.getName());
                    config.register(c);
                    continue;
                }
                LOG.warn("Class {} was not registered as a resource; bind a concrete implementation instead", (Object)c.getName());
            }
            injector = injector.getParent();
        }
    }

    private static boolean isProviderClass(Class<?> c) {
        return c.isAnnotationPresent(Provider.class);
    }

    private static boolean isResourceClass(Class<?> c) {
        if (c.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Class<?> i : c.getInterfaces()) {
            if (!i.isAnnotationPresent(Path.class)) continue;
            return true;
        }
        return false;
    }
}

