/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.immutable.collection.encoding;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ImmutableMapEncoding<K, V> {
    private ImmutableMap<K, V> field = ImmutableMap.of();

    ImmutableMap<K, V> getImmutableMap() {
        return this.field;
    }

    Map<K, V> getMap() {
        return this.field;
    }

    ImmutableMap<K, V> withCollection(Map<K, ? extends V> elements) {
        return ImmutableMap.copyOf(elements);
    }

    static <K, V> ImmutableMap<K, V> of(Map<? extends K, ? extends V> input) {
        return ImmutableMap.copyOf(input);
    }

    static class Builder<K, V> {
        private ImmutableMap<K, V> map = null;
        private ImmutableMap.Builder<K, V> builder = null;

        Builder() {
        }

        void put(K key, V value) {
            if (this.builder != null) {
                this.builder.put(key, value);
            } else if (this.map != null) {
                this.builder = ImmutableMap.builderWithExpectedSize((int)(this.map.size() + 1)).putAll(this.map).put(key, value);
                this.map = null;
            } else {
                this.builder = ImmutableMap.builder();
                this.builder.put(key, value);
            }
        }

        void putEntry(Map.Entry<K, ? extends V> entry) {
            if (this.builder != null) {
                this.builder.put(entry);
            } else if (this.map != null) {
                this.builder = ImmutableMap.builderWithExpectedSize((int)(this.map.size() + 1)).putAll(this.map).put(entry);
                this.map = null;
            } else {
                this.builder = ImmutableMap.builder();
                this.builder.put(entry);
            }
        }

        void putAll(Map<K, ? extends V> elements) {
            if (this.builder != null) {
                this.builder.putAll(elements);
            } else if (this.map != null) {
                this.builder = ImmutableMap.builderWithExpectedSize((int)(this.map.size() + elements.size())).putAll(this.map).putAll(elements);
                this.map = null;
            } else if (elements instanceof ImmutableMap) {
                this.set(elements);
            } else {
                this.builder = ImmutableMap.builderWithExpectedSize((int)elements.size());
                this.builder.putAll(elements);
            }
        }

        void set(Map<K, ? extends V> input) {
            this.map = ImmutableMap.copyOf(input);
            this.builder = null;
        }

        ImmutableMap<K, V> build() {
            if (this.builder != null) {
                return this.builder.build();
            }
            if (this.map != null) {
                return this.map;
            }
            return ImmutableMap.of();
        }
    }
}

