/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.immutable.collection.encoding;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class ImmutableSetEncoding<T> {
    private ImmutableSet<T> field = ImmutableSet.of();

    ImmutableSet<T> getImmutableSet() {
        return this.field;
    }

    Set<T> getSet() {
        return this.field;
    }

    ImmutableSet<T> withCollectionVarargs(T ... elements) {
        return ImmutableSet.copyOf((Object[])elements);
    }

    ImmutableSet<T> withCollection(Iterable<? extends T> elements) {
        return ImmutableSet.copyOf(elements);
    }

    static <T> ImmutableSet<T> of(Collection<? extends T> input) {
        return ImmutableSet.copyOf(input);
    }

    static class Builder<T> {
        private ImmutableSet<T> set = null;
        private ImmutableSet.Builder<T> builder = null;

        Builder() {
        }

        void add(T ... element) {
            if (this.builder != null) {
                this.builder.add((Object[])element);
            } else if (this.set != null) {
                this.builder = ImmutableSet.builderWithExpectedSize((int)(this.set.size() + 1)).addAll(this.set).add((Object[])element);
                this.set = null;
            } else {
                this.builder = ImmutableSet.builder();
                this.builder.add((Object[])element);
            }
        }

        void addAll(Iterable<? extends T> elements) {
            if (this.builder != null) {
                this.builder.addAll(elements);
            } else if (this.set != null) {
                int additionalSize = 0;
                if (elements instanceof Collection) {
                    additionalSize = ((Collection)elements).size();
                }
                this.builder = ImmutableSet.builderWithExpectedSize((int)(this.set.size() + additionalSize)).addAll(this.set).addAll(elements);
                this.set = null;
            } else if (elements instanceof ImmutableCollection) {
                this.set(elements);
            } else if (elements instanceof Collection) {
                this.builder = ImmutableSet.builderWithExpectedSize((int)((Collection)elements).size());
                this.builder.addAll(elements);
            } else {
                this.builder = ImmutableSet.builder();
                this.builder.addAll(elements);
            }
        }

        void set(Iterable<? extends T> input) {
            this.set = ImmutableSet.copyOf(input);
            this.builder = null;
        }

        ImmutableSet<T> build() {
            if (this.builder != null) {
                return this.builder.build();
            }
            if (this.set != null) {
                return this.set;
            }
            return ImmutableSet.of();
        }
    }
}

