/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.dependency.management;

import com.hubspot.maven.plugins.dependency.management.RequireManagement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.SelectorUtils;

public class DependencyManagementAnalyzer {
    private final MavenProject project;
    private final RequireManagement requireManagement;
    private final Log log;

    public DependencyManagementAnalyzer(MavenProject project, RequireManagement requireManagement, Log log) {
        this.project = project;
        this.requireManagement = requireManagement;
        this.log = log;
    }

    public boolean analyze() {
        boolean success = this.checkDependencyManagement();
        return success &= this.checkPluginManagement();
    }

    private boolean checkDependencyManagement() {
        Map<String, Dependency> managedDependencies = DependencyManagementAnalyzer.asMap(this.project.getDependencyManagement().getDependencies());
        boolean success = true;
        for (Dependency projectDependency : this.project.getDependencies()) {
            String dependencyKey = projectDependency.getManagementKey();
            Dependency managedDependency = managedDependencies.get(dependencyKey);
            if (managedDependency != null) {
                String managedVersion;
                String projectVersion = projectDependency.getVersion();
                if (projectVersion.equals(managedVersion = managedDependency.getVersion())) continue;
                String errorFormat = "Version mismatch for %s, managed version %s does not match project version %s";
                this.log.warn((CharSequence)String.format(errorFormat, dependencyKey, managedVersion, projectVersion));
                success = false;
                continue;
            }
            if (!this.requireManagement.requireDependencyManagement() || this.ignored(dependencyKey)) continue;
            this.log.warn((CharSequence)String.format("Dependency %s is not managed", dependencyKey));
            success = false;
        }
        return success;
    }

    private boolean checkPluginManagement() {
        Map managedPlugins = this.project.getPluginManagement().getPluginsAsMap();
        boolean success = true;
        for (Plugin projectPlugin : this.project.getBuildPlugins()) {
            Plugin managedPlugin = (Plugin)managedPlugins.get(projectPlugin.getKey());
            if (managedPlugin != null) {
                String managedVersion;
                String projectVersion = projectPlugin.getVersion();
                if (projectVersion.equals(managedVersion = managedPlugin.getVersion())) continue;
                String errorFormat = "Version mismatch for plugin %s, managed version %s does not match project version %s";
                this.log.warn((CharSequence)String.format(errorFormat, projectPlugin.getKey(), managedVersion, projectVersion));
                success = false;
                continue;
            }
            if (!this.requireManagement.requirePluginManagement() || this.ignored(projectPlugin.getKey())) continue;
            this.log.warn((CharSequence)String.format("Plugin %s is not managed", projectPlugin.getKey()));
            success = false;
        }
        return success;
    }

    private boolean ignored(String key) {
        if (key.indexOf(58) != key.lastIndexOf(58)) {
            key = key.substring(0, key.indexOf(58, key.indexOf(58) + 1));
        }
        for (String exception : this.requireManagement.getExceptions()) {
            if (!SelectorUtils.match((String)exception, (String)key)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Dependency> asMap(List<Dependency> dependencies) {
        HashMap<String, Dependency> dependencyMap = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            dependencyMap.put(dependency.getManagementKey(), dependency);
        }
        return dependencyMap;
    }
}

