/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.dependency.management;

import com.hubspot.maven.plugins.dependency.management.DependencyManagementAnalyzer;
import com.hubspot.maven.plugins.dependency.management.RequireManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="analyze", requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class DependencyManagementMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private RequireManagement requireManagement = new RequireManagement();
    @Parameter(defaultValue="false")
    private boolean fail;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        boolean success = new DependencyManagementAnalyzer(this.project, this.requireManagement, this.getLog()).analyze();
        if (success) {
            this.getLog().info((CharSequence)"No dependency management issues found");
        } else if (this.fail) {
            throw new MojoExecutionException("Dependency management issues found");
        }
    }
}

