"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.InterfacesPrettierVisitor = void 0;
var prettier_builder_1 = require("./prettier-builder");
var format_comments_1 = require("./comments/format-comments");
var printer_utils_1 = require("./printer-utils");
var doc_1 = require("prettier/doc");
var base_cst_printer_1 = require("../base-cst-printer");
var line = doc_1.builders.line, softline = doc_1.builders.softline, hardline = doc_1.builders.hardline;
var InterfacesPrettierVisitor = /** @class */ (function (_super) {
    __extends(InterfacesPrettierVisitor, _super);
    function InterfacesPrettierVisitor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    InterfacesPrettierVisitor.prototype.interfaceDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.interfaceModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var declaration = ctx.normalInterfaceDeclaration
            ? this.visit(ctx.normalInterfaceDeclaration)
            : this.visit(ctx.annotationTypeDeclaration);
        return printer_utils_1.rejectAndJoin(hardline, [
            printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
            printer_utils_1.rejectAndJoin(" ", [printer_utils_1.rejectAndJoin(" ", otherModifiers), declaration])
        ]);
    };
    InterfacesPrettierVisitor.prototype.normalInterfaceDeclaration = function (ctx) {
        var typeIdentifier = this.visit(ctx.typeIdentifier);
        var typeParameters = this.visit(ctx.typeParameters);
        var extendsInterfaces = this.visit(ctx.extendsInterfaces);
        var optionalInterfacePermits = this.visit(ctx.interfacePermits);
        var interfaceBody = this.visit(ctx.interfaceBody);
        var extendsInterfacesPart = "";
        if (extendsInterfaces) {
            extendsInterfacesPart = prettier_builder_1.indent(printer_utils_1.rejectAndConcat([softline, extendsInterfaces]));
        }
        var interfacePermits = "";
        if (optionalInterfacePermits) {
            interfacePermits = prettier_builder_1.indent(printer_utils_1.rejectAndConcat([softline, optionalInterfacePermits]));
        }
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.group(printer_utils_1.rejectAndJoin(" ", [
                ctx.Interface[0],
                prettier_builder_1.concat([typeIdentifier, typeParameters]),
                extendsInterfacesPart,
                interfacePermits
            ])),
            interfaceBody
        ]);
    };
    InterfacesPrettierVisitor.prototype.interfaceModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visitSingle(ctx);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    InterfacesPrettierVisitor.prototype.extendsInterfaces = function (ctx) {
        var interfaceTypeList = this.visit(ctx.interfaceTypeList);
        return prettier_builder_1.group(printer_utils_1.rejectAndConcat([
            ctx.Extends[0],
            prettier_builder_1.indent(printer_utils_1.rejectAndConcat([line, interfaceTypeList]))
        ]));
    };
    InterfacesPrettierVisitor.prototype.interfacePermits = function (ctx) {
        return this.classPermits(ctx);
    };
    InterfacesPrettierVisitor.prototype.interfaceBody = function (ctx) {
        var joinedInterfaceMemberDeclaration = "";
        if (ctx.interfaceMemberDeclaration !== undefined) {
            var interfaceMemberDeclaration = this.mapVisit(ctx.interfaceMemberDeclaration);
            var separators = printer_utils_1.getInterfaceBodyDeclarationsSeparator(ctx.interfaceMemberDeclaration);
            joinedInterfaceMemberDeclaration = printer_utils_1.rejectAndJoinSeps(separators, interfaceMemberDeclaration);
        }
        return printer_utils_1.putIntoBraces(joinedInterfaceMemberDeclaration, hardline, ctx.LCurly[0], ctx.RCurly[0]);
    };
    InterfacesPrettierVisitor.prototype.interfaceMemberDeclaration = function (ctx) {
        if (ctx.Semicolon) {
            return printer_utils_1.displaySemicolon(ctx.Semicolon[0]);
        }
        return this.visitSingle(ctx);
    };
    InterfacesPrettierVisitor.prototype.constantDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.constantModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var unannType = this.visit(ctx.unannType);
        var variableDeclaratorList = this.visit(ctx.variableDeclaratorList);
        return printer_utils_1.rejectAndJoin(hardline, [
            printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
            printer_utils_1.rejectAndJoin(" ", [
                printer_utils_1.rejectAndJoin(" ", otherModifiers),
                unannType,
                printer_utils_1.rejectAndConcat([variableDeclaratorList, ctx.Semicolon[0]])
            ])
        ]);
    };
    InterfacesPrettierVisitor.prototype.constantModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visitSingle(ctx);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    InterfacesPrettierVisitor.prototype.interfaceMethodDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.interfaceMethodModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var methodHeader = this.visit(ctx.methodHeader);
        var methodBody = this.visit(ctx.methodBody);
        var separator = printer_utils_1.isStatementEmptyStatement(methodBody) ? "" : " ";
        return printer_utils_1.rejectAndJoin(hardline, [
            printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
            printer_utils_1.rejectAndJoin(" ", [
                printer_utils_1.rejectAndJoin(" ", otherModifiers),
                printer_utils_1.rejectAndJoin(separator, [methodHeader, methodBody])
            ])
        ]);
    };
    InterfacesPrettierVisitor.prototype.interfaceMethodModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visitSingle(ctx);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    InterfacesPrettierVisitor.prototype.annotationTypeDeclaration = function (ctx) {
        var typeIdentifier = this.visit(ctx.typeIdentifier);
        var annotationTypeBody = this.visit(ctx.annotationTypeBody);
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.concat([ctx.At[0], ctx.Interface[0]]),
            typeIdentifier,
            annotationTypeBody
        ]);
    };
    InterfacesPrettierVisitor.prototype.annotationTypeBody = function (ctx) {
        var annotationTypeMemberDeclaration = this.mapVisit(ctx.annotationTypeMemberDeclaration);
        return printer_utils_1.rejectAndJoin(line, [
            prettier_builder_1.indent(printer_utils_1.rejectAndJoin(line, [
                ctx.LCurly[0],
                printer_utils_1.rejectAndJoin(prettier_builder_1.concat([line, line]), annotationTypeMemberDeclaration)
            ])),
            ctx.RCurly[0]
        ]);
    };
    InterfacesPrettierVisitor.prototype.annotationTypeMemberDeclaration = function (ctx) {
        if (ctx.Semicolon) {
            return format_comments_1.printTokenWithComments(this.getSingle(ctx));
        }
        return this.visitSingle(ctx);
    };
    InterfacesPrettierVisitor.prototype.annotationTypeElementDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.annotationTypeElementModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var unannType = this.visit(ctx.unannType);
        var identifier = ctx.Identifier[0];
        var dims = this.visit(ctx.dims);
        var defaultValue = ctx.defaultValue
            ? prettier_builder_1.concat([" ", this.visit(ctx.defaultValue)])
            : "";
        return printer_utils_1.rejectAndJoin(hardline, [
            printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
            printer_utils_1.rejectAndJoin(" ", [
                printer_utils_1.rejectAndJoin(" ", otherModifiers),
                unannType,
                printer_utils_1.rejectAndConcat([
                    identifier,
                    prettier_builder_1.concat([ctx.LBrace[0], ctx.RBrace[0]]),
                    dims,
                    defaultValue,
                    ctx.Semicolon[0]
                ])
            ])
        ]);
    };
    InterfacesPrettierVisitor.prototype.annotationTypeElementModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visitSingle(ctx);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    InterfacesPrettierVisitor.prototype.defaultValue = function (ctx) {
        var elementValue = this.visit(ctx.elementValue);
        return printer_utils_1.rejectAndJoin(" ", [ctx.Default[0], elementValue]);
    };
    InterfacesPrettierVisitor.prototype.annotation = function (ctx) {
        var fqn = this.visit(ctx.typeName);
        var annoArgs = "";
        if (ctx.LBrace) {
            if (ctx.elementValuePairList) {
                annoArgs = printer_utils_1.putIntoBraces(this.visit(ctx.elementValuePairList), softline, ctx.LBrace[0], ctx.RBrace[0]);
            }
            else if (ctx.elementValue) {
                annoArgs = printer_utils_1.putIntoBraces(this.visit(ctx.elementValue), softline, ctx.LBrace[0], ctx.RBrace[0]);
            }
        }
        return prettier_builder_1.group(printer_utils_1.rejectAndConcat([ctx.At[0], fqn, annoArgs]));
    };
    InterfacesPrettierVisitor.prototype.elementValuePairList = function (ctx) {
        var elementValuePairs = this.mapVisit(ctx.elementValuePair);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, line]); }) : [];
        return printer_utils_1.rejectAndJoinSeps(commas, elementValuePairs);
    };
    InterfacesPrettierVisitor.prototype.elementValuePair = function (ctx) {
        var identifier = ctx.Identifier[0];
        var elementValue = this.visit(ctx.elementValue);
        return printer_utils_1.rejectAndJoin(" ", [identifier, ctx.Equals[0], elementValue]);
    };
    InterfacesPrettierVisitor.prototype.elementValue = function (ctx) {
        return this.visitSingle(ctx);
    };
    InterfacesPrettierVisitor.prototype.elementValueArrayInitializer = function (ctx) {
        var elementValueList = this.visit(ctx.elementValueList);
        return printer_utils_1.printArrayList({
            list: elementValueList,
            extraComma: ctx.Comma,
            LCurly: ctx.LCurly[0],
            RCurly: ctx.RCurly[0],
            trailingComma: this.prettierOptions.trailingComma
        });
    };
    InterfacesPrettierVisitor.prototype.elementValueList = function (ctx) {
        var elementValues = this.mapVisit(ctx.elementValue);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, line]); }) : [];
        return prettier_builder_1.group(printer_utils_1.rejectAndConcat([printer_utils_1.rejectAndJoinSeps(commas, elementValues)]));
    };
    InterfacesPrettierVisitor.prototype.identifyInterfaceBodyDeclarationType = function () {
        return "identifyInterfaceBodyDeclarationType";
    };
    InterfacesPrettierVisitor.prototype.identifyAnnotationBodyDeclarationType = function () {
        return "identifyAnnotationBodyDeclarationType";
    };
    InterfacesPrettierVisitor.prototype.isSimpleElementValueAnnotation = function () {
        return "isSimpleElementValueAnnotation";
    };
    return InterfacesPrettierVisitor;
}(base_cst_printer_1.BaseCstPrettierPrinter));
exports.InterfacesPrettierVisitor = InterfacesPrettierVisitor;
