"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var doc_1 = require("prettier/doc");
var expressions_utils_1 = require("./expressions-utils");
var printer_utils_1 = require("../printers/printer-utils");
var printSingleLambdaInvocation_1 = __importDefault(require("./printSingleLambdaInvocation"));
var softline = doc_1.builders.softline;
function printArgumentListWithBraces(argumentListCtx, rBrace, lBrace) {
    var isSingleLambda = expressions_utils_1.isArgumentListSingleLambda(argumentListCtx);
    if (isSingleLambda) {
        return printSingleLambdaInvocation_1.default.call(this, argumentListCtx, rBrace, lBrace);
    }
    var argumentList = this.visit(argumentListCtx, {
        isInsideMethodInvocationSuffix: true
    });
    return printer_utils_1.putIntoBraces(argumentList, softline, lBrace, rBrace);
}
exports.default = printArgumentListWithBraces;
