/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier;

import com.hubspot.maven.plugins.prettier.AbstractPrettierMojo;
import com.hubspot.maven.plugins.prettier.diff.DiffGenerator;
import com.hubspot.maven.plugins.prettier.diff.GenerateDiffArgs;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", threadSafe=true)
public class CheckMojo
extends AbstractPrettierMojo {
    private static final String MESSAGE = "Code formatting issues found, please run prettier-java";
    @Parameter(defaultValue="true")
    private boolean fail;
    @Parameter(defaultValue="false")
    private boolean generateDiff;
    @Parameter(property="prettier.diffGenerator", alias="diffGenerator", defaultValue="com.hubspot.maven.plugins.prettier.diff.DefaultDiffGenerator")
    private String diffGeneratorType;
    private final List<Path> incorrectlyFormattedFiles = new ArrayList<Path>();

    @Override
    protected String getPrettierCommand() {
        return "check";
    }

    @Override
    protected void handlePrettierLogLine(String line) {
        Path maybeFile = this.resolveFile(line = CheckMojo.trimLogLevel(line));
        if (Files.isRegularFile(maybeFile, new LinkOption[0])) {
            this.incorrectlyFormattedFiles.add(maybeFile);
            String message = "Incorrectly formatted file: " + line;
            if (this.fail) {
                this.getLog().error((CharSequence)message);
            } else {
                this.getLog().warn((CharSequence)message);
            }
        }
    }

    @Override
    protected void handlePrettierNonZeroExit(int status) throws MojoFailureException, MojoExecutionException {
        if (this.incorrectlyFormattedFiles.isEmpty()) {
            return;
        }
        if (this.generateDiff) {
            this.generateDiff();
        }
        if (this.fail) {
            this.getLog().error((CharSequence)MESSAGE);
            throw new MojoFailureException(MESSAGE);
        }
        this.getLog().warn((CharSequence)MESSAGE);
    }

    private void generateDiff() throws MojoExecutionException, MojoFailureException {
        DiffGenerator diffGenerator = this.instantiateDiffGenerator();
        GenerateDiffArgs args = new GenerateDiffArgs(this.incorrectlyFormattedFiles, this.basePrettierCommand(), this.project, this.getLog());
        diffGenerator.generateDiffs(args);
    }

    private DiffGenerator instantiateDiffGenerator() throws MojoExecutionException {
        try {
            return (DiffGenerator)Class.forName(this.diffGeneratorType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to find diff generator implementation", (Exception)e);
        }
        catch (ReflectiveOperationException e) {
            throw new MojoExecutionException("Unable to instantiate diff generator", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException("Must implement DiffGenerator interface", (Exception)e);
        }
    }

    private Path resolveFile(String relativePath) {
        Path baseDir = this.project.getBasedir().toPath().toAbsolutePath();
        return baseDir.resolve(relativePath);
    }
}

