/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class PrettierArgs
extends AbstractMojo {
    private static final Set<PosixFilePermission> GLOBAL_PERMISSIONS = PosixFilePermissions.fromString("rwxrwxrwx");
    private static final Object RESOLUTION_LOCK = new Object();
    private static final Object EXTRACTION_LOCK = new Object();
    @Parameter(defaultValue="${project}", readonly=true, required=false)
    protected MavenProject project;
    @Parameter(defaultValue="12.13.0", property="prettier.nodeVersion")
    private String nodeVersion;
    @Parameter(defaultValue="", property="prettier.nodePath")
    private String nodePath;
    @Parameter(defaultValue="0.7.0", property="prettier.prettierJavaVersion")
    private String prettierJavaVersion;
    @Parameter(defaultValue="false")
    private boolean extractPrettierToTargetDirectory;
    @Nullable
    @Parameter(property="prettier.printWidth")
    protected String printWidth;
    @Nullable
    @Parameter(property="prettier.tabWidth")
    protected String tabWidth;
    @Nullable
    @Parameter(property="prettier.useTabs")
    protected Boolean useTabs;
    @Parameter(defaultValue="false", property="prettier.ignoreConfigFile")
    protected boolean ignoreConfigFile;
    @Parameter(defaultValue="false", property="prettier.ignoreEditorConfig")
    protected boolean ignoreEditorConfig;
    @Nullable
    @Parameter(property="prettier.endOfLine")
    protected String endOfLine;
    @Parameter(property="prettier.inputGlobs")
    protected List<String> inputGlobs;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Component
    private PluginDescriptor pluginDescriptor;
    @Component
    private RepositorySystem repositorySystem;

    protected Path resolveNodeExecutable() throws MojoExecutionException {
        File nodeExecutable;
        if (this.nodePath != null && !this.nodePath.isEmpty()) {
            this.getLog().info((CharSequence)("Using customized nodePath: " + this.nodePath));
            return Paths.get(this.nodePath, new String[0]);
        }
        DefaultArtifact nodeArtifact = new DefaultArtifact(this.pluginDescriptor.getGroupId(), this.pluginDescriptor.getArtifactId(), this.determineNodeClassifier(), "exe", this.pluginDescriptor.getVersion());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolving node artifact " + nodeArtifact));
        }
        if (!(nodeExecutable = this.resolve((Artifact)nodeArtifact).getFile()).setExecutable(true, false)) {
            throw new MojoExecutionException("Unable to make file executable " + nodeExecutable);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolved node artifact to " + nodeExecutable));
        }
        return nodeExecutable.toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path extractPrettierJava() throws MojoExecutionException {
        DefaultArtifact prettierArtifact = new DefaultArtifact(this.pluginDescriptor.getGroupId(), this.pluginDescriptor.getArtifactId(), this.determinePrettierJavaClassifier(), "zip", this.pluginDescriptor.getVersion());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolving prettier-java artifact " + prettierArtifact));
        }
        prettierArtifact = this.resolve((Artifact)prettierArtifact);
        Path extractionPath = this.determinePrettierJavaExtractionPath((Artifact)prettierArtifact);
        Object object = EXTRACTION_LOCK;
        synchronized (object) {
            if (Files.isDirectory(extractionPath, new LinkOption[0])) {
                this.getLog().debug((CharSequence)("Reusing cached prettier-java at " + extractionPath));
                return extractionPath;
            }
            Path tempDir = extractionPath.resolveSibling(UUID.randomUUID().toString());
            try {
                Files.createDirectories(tempDir, this.determineOperatingSystemFamily().getGlobalPermissions());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating temp directory: " + tempDir, (Exception)e);
            }
            this.getLog().debug((CharSequence)("Extracting prettier-java to " + tempDir));
            File prettierZip = prettierArtifact.getFile();
            try {
                new ZipFile(prettierZip).extractAll(tempDir.toString());
            }
            catch (ZipException e) {
                throw new MojoExecutionException("Error extracting prettier " + prettierZip, (Exception)((Object)e));
            }
            this.getLog().debug((CharSequence)("Copying prettier-java to " + extractionPath));
            try {
                Files.move(tempDir, extractionPath, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                if (PrettierArgs.isIgnorableMoveError(e)) {
                    this.getLog().debug((CharSequence)("Directory already created at: " + extractionPath));
                }
                String message = String.format("Error moving directory from %s to %s", tempDir, extractionPath);
                throw new MojoExecutionException(message, (Exception)e);
            }
            return extractionPath;
        }
    }

    protected List<String> computeInputGlobs() {
        if (this.inputGlobs.isEmpty()) {
            return this.defaultInputGlobs();
        }
        return this.inputGlobs;
    }

    private List<String> defaultInputGlobs() {
        ArrayList<String> defaultGlobs = new ArrayList<String>();
        Path sourceDirectory = Paths.get(this.project.getBuild().getSourceDirectory(), new String[0]);
        Path testSourceDirectory = Paths.get(this.project.getBuild().getTestSourceDirectory(), new String[0]);
        if (Files.isDirectory(sourceDirectory, new LinkOption[0])) {
            defaultGlobs.add(this.project.getBasedir().toPath().relativize(sourceDirectory) + "/**/*.java");
        }
        if (Files.isDirectory(testSourceDirectory, new LinkOption[0])) {
            defaultGlobs.add(this.project.getBasedir().toPath().relativize(testSourceDirectory) + "/**/*.java");
        }
        return defaultGlobs;
    }

    private Path determinePrettierJavaExtractionPath(Artifact prettierArtifact) {
        String directoryName = String.join((CharSequence)"-", prettierArtifact.getArtifactId(), prettierArtifact.getVersion(), prettierArtifact.getClassifier());
        if (this.extractPrettierToTargetDirectory || PrettierArgs.isUnresolvedSnapshot(prettierArtifact)) {
            return Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(directoryName);
        }
        return prettierArtifact.getFile().toPath().resolveSibling(directoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Artifact resolve(Artifact artifact) throws MojoExecutionException {
        ArtifactResult result;
        ArtifactRequest artifactRequest = new ArtifactRequest().setArtifact(artifact).setRepositories(this.project.getRemoteProjectRepositories());
        try {
            Object object = RESOLUTION_LOCK;
            synchronized (object) {
                result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error resolving artifact " + this.nodeVersion, (Exception)((Object)e));
        }
        return result.getArtifact();
    }

    private String determinePrettierJavaClassifier() {
        return "prettier-java-" + this.prettierJavaVersion;
    }

    private String determineNodeClassifier() throws MojoExecutionException {
        OperatingSystemFamily osFamily = this.determineOperatingSystemFamily();
        return "node-" + this.nodeVersion + "-" + osFamily.getShortName();
    }

    private OperatingSystemFamily determineOperatingSystemFamily() throws MojoExecutionException {
        String osFullName = System.getProperty("os.name");
        if (osFullName == null) {
            throw new MojoExecutionException("No os.name system property set");
        }
        if ((osFullName = osFullName.toLowerCase()).startsWith("linux")) {
            return OperatingSystemFamily.LINUX;
        }
        if (osFullName.startsWith("mac os x")) {
            return OperatingSystemFamily.MAC_OS_X;
        }
        if (osFullName.startsWith("windows")) {
            return OperatingSystemFamily.WINDOWS;
        }
        throw new MojoExecutionException("Unknown os.name " + osFullName);
    }

    private static boolean isIgnorableMoveError(IOException e) {
        return e instanceof FileAlreadyExistsException || e instanceof DirectoryNotEmptyException || e instanceof FileSystemException && e.getMessage().contains("Directory not empty");
    }

    private static boolean isUnresolvedSnapshot(Artifact artifact) {
        return artifact.isSnapshot() && artifact.getVersion().endsWith("-SNAPSHOT");
    }

    private static enum OperatingSystemFamily {
        LINUX("linux"),
        MAC_OS_X("mac_os_x"),
        WINDOWS("windows");

        private String shortName;

        private OperatingSystemFamily(String shortName) {
            this.shortName = shortName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public FileAttribute<?>[] getGlobalPermissions() {
            if (this == WINDOWS) {
                return new FileAttribute[0];
            }
            return new FileAttribute[]{PosixFilePermissions.asFileAttribute(GLOBAL_PERMISSIONS)};
        }
    }
}

