/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier;

import com.hubspot.maven.plugins.prettier.internal.NodeDownloader;
import com.hubspot.maven.plugins.prettier.internal.NodeInstall;
import com.hubspot.maven.plugins.prettier.internal.OperatingSystemFamily;
import com.hubspot.maven.plugins.prettier.internal.PrettierDownloader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class PrettierArgs
extends AbstractMojo {
    private static final Object NODE_DOWNLOAD_LOCK = new Object();
    private static final Object PRETTIER_JAVA_DOWNLOAD_LOCK = new Object();
    @Parameter(defaultValue="${project}", readonly=true, required=false)
    protected MavenProject project;
    @Parameter(defaultValue="${settings.localRepository}")
    private String localRepository;
    @Parameter(defaultValue="16.13.2", property="prettier.nodeVersion")
    private String nodeVersion;
    @Parameter(defaultValue="", property="prettier.nodePath")
    private String nodePath;
    @Parameter(defaultValue="", property="prettier.npmPath")
    private String npmPath;
    @Parameter(defaultValue="0.7.0", property="prettier.prettierJavaVersion")
    private String prettierJavaVersion;
    @Parameter(defaultValue="false")
    private boolean extractPrettierToTargetDirectory;
    @Nullable
    @Parameter(property="prettier.printWidth")
    protected String printWidth;
    @Nullable
    @Parameter(property="prettier.tabWidth")
    protected String tabWidth;
    @Nullable
    @Parameter(property="prettier.useTabs")
    protected Boolean useTabs;
    @Parameter(defaultValue="false", property="prettier.ignoreConfigFile")
    protected boolean ignoreConfigFile;
    @Parameter(defaultValue="false", property="prettier.ignoreEditorConfig")
    protected boolean ignoreEditorConfig;
    @Nullable
    @Parameter(property="prettier.endOfLine")
    protected String endOfLine;
    @Parameter(property="prettier.inputGlobs")
    protected List<String> inputGlobs;
    @Component
    private PluginDescriptor pluginDescriptor;

    protected NodeInstall resolveNodeInstall() throws MojoExecutionException {
        Optional<Object> maybeNode = Optional.empty();
        Optional<Object> maybeNpm = Optional.empty();
        if (this.nodePath != null && !this.nodePath.isEmpty()) {
            this.getLog().info((CharSequence)("Using customized nodePath: " + this.nodePath));
            maybeNode = Optional.of(this.nodePath);
        }
        if (this.npmPath != null && !this.npmPath.isEmpty()) {
            this.getLog().info((CharSequence)("Using customized npmPath: " + this.npmPath));
            maybeNpm = Optional.of(this.npmPath);
        }
        if (maybeNode.isPresent() && maybeNpm.isPresent()) {
            return new NodeInstall((String)maybeNode.get(), Arrays.asList((String)maybeNpm.get()));
        }
        NodeInstall nodeInstall = this.downloadNode();
        if (maybeNode.isPresent()) {
            return new NodeInstall((String)maybeNode.get(), nodeInstall.getNpmCommand());
        }
        if (maybeNpm.isPresent()) {
            return new NodeInstall(nodeInstall.getNodePath(), Arrays.asList((String)maybeNpm.get()));
        }
        return nodeInstall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path downloadPrettierJava(NodeInstall nodeInstall) throws MojoExecutionException {
        Object object = PRETTIER_JAVA_DOWNLOAD_LOCK;
        synchronized (object) {
            Path installDirectory = this.localRepositoryDirectory();
            PrettierDownloader prettierDownloader = new PrettierDownloader(installDirectory, nodeInstall, this.getLog());
            return prettierDownloader.downloadPrettierJava(this.prettierJavaVersion);
        }
    }

    private NodeInstall downloadNode() throws MojoExecutionException {
        Object object = NODE_DOWNLOAD_LOCK;
        synchronized (object) {
            Path installDirectory = this.localRepositoryDirectory();
            try {
                NodeDownloader nodeDownloader = new NodeDownloader(installDirectory, this.getLog());
                return nodeDownloader.download(this.nodeVersion);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error downloading node", (Exception)e);
            }
        }
    }

    private Path localRepositoryDirectory() throws MojoExecutionException {
        Path localRepositoryDirectory = Paths.get(this.localRepository, new String[0]).resolve(this.pluginDescriptor.getGroupId().replace('.', File.separatorChar)).resolve(this.pluginDescriptor.getArtifactId()).resolve(this.pluginDescriptor.getVersion());
        try {
            Files.createDirectories(localRepositoryDirectory, OperatingSystemFamily.current().getGlobalPermissions());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating directory: " + localRepositoryDirectory, (Exception)e);
        }
        return localRepositoryDirectory;
    }

    protected List<String> computeInputGlobs() {
        if (this.inputGlobs.isEmpty()) {
            return this.defaultInputGlobs();
        }
        return this.inputGlobs;
    }

    private List<String> defaultInputGlobs() {
        ArrayList<String> defaultGlobs = new ArrayList<String>();
        Path sourceDirectory = Paths.get(this.project.getBuild().getSourceDirectory(), new String[0]);
        Path testSourceDirectory = Paths.get(this.project.getBuild().getTestSourceDirectory(), new String[0]);
        if (Files.isDirectory(sourceDirectory, new LinkOption[0])) {
            defaultGlobs.add(this.project.getBasedir().toPath().relativize(sourceDirectory) + "/**/*.java");
        }
        if (Files.isDirectory(testSourceDirectory, new LinkOption[0])) {
            defaultGlobs.add(this.project.getBasedir().toPath().relativize(testSourceDirectory) + "/**/*.java");
        }
        return defaultGlobs;
    }
}

