/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier.internal;

import com.hubspot.maven.plugins.prettier.internal.FileUtils;
import com.hubspot.maven.plugins.prettier.internal.NodeInstall;
import com.hubspot.maven.plugins.prettier.internal.OperatingSystemFamily;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class NodeDownloader {
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient();
    private final Path installDirectory;
    private final Log log;

    public NodeDownloader(Path installDirectory, Log log) {
        this.installDirectory = installDirectory;
        this.log = log;
    }

    public NodeInstall download(String version) throws MojoExecutionException, IOException {
        OperatingSystemFamily os = OperatingSystemFamily.current();
        this.log.debug((CharSequence)("Determined os: " + (Object)((Object)os)));
        Path targetDirectory = this.installDirectory.resolve(os.getNodeDirectoryName(version));
        if (Files.exists(targetDirectory, new LinkOption[0])) {
            this.log.debug((CharSequence)("Reusing cached node at: " + targetDirectory));
        } else {
            String downloadUrl = os.getNodeDownloadUrl(version);
            this.log.debug((CharSequence)("Downloading node from url: " + downloadUrl));
            Path nodeArchive = this.downloadToTmpFile(downloadUrl);
            this.log.debug((CharSequence)("Downloaded node to: " + nodeArchive));
            Path tmpDir = os.extractToTmpDir(this.installDirectory, nodeArchive);
            Files.delete(nodeArchive);
            this.log.debug((CharSequence)("Extracted node to: " + tmpDir));
            Path nodeDir = tmpDir.resolve(os.getNodeDirectoryName(version));
            if (os != OperatingSystemFamily.WINDOWS_X64) {
                NodeInstall nodeInstall = os.toNodeInstall(nodeDir);
                os.setGlobalPermissions(Paths.get(nodeInstall.getNodePath(), new String[0]));
            }
            FileUtils.move(nodeDir, targetDirectory);
            Files.delete(tmpDir);
            this.log.debug((CharSequence)("Moved node to: " + targetDirectory));
        }
        return os.toNodeInstall(targetDirectory);
    }

    private Path downloadToTmpFile(String downloadUrl) throws IOException {
        Request request = new Request.Builder().url(downloadUrl).build();
        try (Response response = HTTP_CLIENT.newCall(request).execute();){
            Path path;
            block12: {
                InputStream responseStream = NodeDownloader.responseStream(response);
                try {
                    Path tempFile = Files.createTempFile(this.installDirectory, "node-", ".tmp", new FileAttribute[0]);
                    Files.copy(responseStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    tempFile.toFile().deleteOnExit();
                    path = tempFile;
                    if (responseStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (responseStream != null) {
                        try {
                            responseStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                responseStream.close();
            }
            return path;
        }
    }

    private static InputStream responseStream(Response response) throws IOException {
        ResponseBody body = response.body();
        if (body == null) {
            throw new IOException("Null body returned for response: " + response);
        }
        return body.byteStream();
    }
}

