/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier.internal;

import com.hubspot.maven.plugins.prettier.internal.FileUtils;
import com.hubspot.maven.plugins.prettier.internal.NodeInstall;
import com.hubspot.maven.plugins.prettier.internal.OperatingSystemFamily;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class PrettierDownloader {
    private final Path installDirectory;
    private final NodeInstall nodeInstall;
    private final Log log;

    public PrettierDownloader(Path installDirectory, NodeInstall nodeInstall, Log log) {
        this.installDirectory = installDirectory;
        this.nodeInstall = nodeInstall;
        this.log = log;
    }

    public Path downloadPrettierJava(String prettierJavaVersion) throws MojoExecutionException {
        Path prettierDirectory = this.installDirectory.resolve("prettier-java-" + prettierJavaVersion);
        if (Files.exists(prettierDirectory, new LinkOption[0])) {
            this.log.debug((CharSequence)("Reusing cached prettier-java at: " + prettierDirectory));
        } else {
            try {
                Path tmpDir = this.installPrettierJavaToTmpDir(prettierJavaVersion);
                FileUtils.move(tmpDir, prettierDirectory);
                this.log.debug((CharSequence)("Downloaded prettier-java to: " + prettierDirectory));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error downloading prettier-java", (Exception)e);
            }
        }
        return prettierDirectory;
    }

    private Path installPrettierJavaToTmpDir(String prettierJavaVersion) throws MojoExecutionException, IOException {
        Path tmpDir = Files.createTempDirectory(this.installDirectory, "prettier-java-", OperatingSystemFamily.current().getGlobalPermissions());
        ArrayList<String> command = new ArrayList<String>(this.nodeInstall.getNpmCommand());
        command.add("install");
        command.add("--prefix");
        command.add(".");
        command.add("prettier-plugin-java@" + prettierJavaVersion);
        this.log.debug((CharSequence)("Running npm install command: " + command));
        Process process = new ProcessBuilder(command.toArray(new String[0])).directory(tmpDir.toFile()).inheritIO().start();
        try {
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new MojoExecutionException("Error downloading prettier-java, exit code: " + exitCode);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted while downloading prettier-java", (Exception)e);
        }
        return tmpDir;
    }
}

