/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier.internal;

import com.hubspot.maven.plugins.prettier.internal.FileUtils;
import com.hubspot.maven.plugins.prettier.internal.NodeInstall;
import com.hubspot.maven.plugins.prettier.internal.OperatingSystemFamily;
import com.hubspot.maven.plugins.prettier.internal.PrettierPaths;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class PrettierDownloader {
    private final Path installDirectory;
    private final NodeInstall nodeInstall;
    private final Log log;

    public PrettierDownloader(Path installDirectory, NodeInstall nodeInstall, Log log) {
        this.installDirectory = installDirectory;
        this.nodeInstall = nodeInstall;
        this.log = log;
    }

    public Path downloadPrettierJava(String prettierJavaVersion) throws MojoExecutionException {
        Path prettierDirectory = this.installDirectory.resolve("prettier-java-" + prettierJavaVersion);
        Path prettierBin = prettierDirectory.resolve(PrettierPaths.prettierBinPath(prettierJavaVersion));
        if (Files.exists(prettierDirectory, new LinkOption[0]) && Files.exists(prettierBin, new LinkOption[0])) {
            this.log.debug((CharSequence)("Reusing cached prettier-java at: " + prettierDirectory));
            return prettierDirectory;
        }
        if (Files.exists(prettierDirectory, new LinkOption[0]) && !Files.exists(prettierBin, new LinkOption[0])) {
            this.log.warn((CharSequence)"Corrupted prettier install, going to delete and re-download");
            FileUtils.deleteDirectory(prettierDirectory);
        }
        try {
            Path tmpDir = this.installPrettierJavaToTmpDir(prettierJavaVersion);
            FileUtils.move(tmpDir, prettierDirectory);
            this.log.info((CharSequence)("Downloaded prettier-java to: " + prettierDirectory));
            return prettierDirectory;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error downloading prettier-java", (Exception)e);
        }
    }

    private Path installPrettierJavaToTmpDir(String prettierJavaVersion) throws MojoExecutionException, IOException {
        Path tmpDir = Files.createTempDirectory(this.installDirectory, "prettier-java-", OperatingSystemFamily.current().getGlobalPermissions());
        ArrayList<String> command = new ArrayList<String>(this.nodeInstall.getNpmCommand());
        command.add("install");
        command.add("--prefix");
        command.add(".");
        command.add("prettier-plugin-java@" + prettierJavaVersion);
        this.log.debug((CharSequence)("Running npm install command: " + command));
        Process process = new ProcessBuilder(command.toArray(new String[0])).directory(tmpDir.toFile()).inheritIO().start();
        try {
            int exitCode = process.waitFor();
            boolean prettierBinExists = Files.exists(tmpDir.resolve(PrettierPaths.prettierBinPath(prettierJavaVersion)), new LinkOption[0]);
            if (exitCode != 0) {
                throw new MojoExecutionException("Error downloading prettier-java, exit code: " + exitCode);
            }
            if (!prettierBinExists) {
                throw new MojoExecutionException("Error downloading prettier-java, prettier bin was not found");
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted while downloading prettier-java", (Exception)e);
        }
        return tmpDir;
    }
}

