/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier;

import com.hubspot.maven.plugins.prettier.PrettierArgs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractPrettierMojo
extends PrettierArgs {
    @Parameter(defaultValue="false")
    private boolean skip;

    protected abstract String getPrettierCommand();

    protected abstract void handlePrettierLogLine(String var1);

    protected abstract void handlePrettierNonZeroExit(int var1) throws MojoExecutionException, MojoFailureException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        List<Path> inputDirectories = this.determineInputPaths();
        if (inputDirectories.isEmpty()) {
            this.getLog().info((CharSequence)"No input directories found");
            return;
        }
        try {
            String glob = this.computeGlob(inputDirectories);
            ArrayList<String> command = new ArrayList<String>(this.basePrettierCommand());
            command.add("--" + this.getPrettierCommand());
            command.add(glob);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Running prettier with args " + command));
            }
            Process process = new ProcessBuilder(command.toArray(new String[0])).directory(this.project.getBasedir()).start();
            try (InputStreamReader stdoutReader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
                 BufferedReader stdout = new BufferedReader(stdoutReader);
                 InputStreamReader stderrReader = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
                 BufferedReader stderr = new BufferedReader(stderrReader);){
                String line;
                while ((line = stdout.readLine()) != null) {
                    this.handlePrettierLogLine(line);
                }
                boolean noMatchingFiles = false;
                while ((line = stderr.readLine()) != null) {
                    if (line.contains("No matching files.")) {
                        noMatchingFiles = true;
                        continue;
                    }
                    if (line.contains("error")) {
                        this.getLog().error((CharSequence)line);
                        continue;
                    }
                    this.getLog().warn((CharSequence)line);
                }
                int status = process.waitFor();
                if (status != 0) {
                    if (status == 2 && noMatchingFiles) {
                        this.getLog().info((CharSequence)("No files found matching glob " + glob));
                    } else {
                        this.handlePrettierNonZeroExit(status);
                    }
                }
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Error trying to run prettier-java", e);
        }
    }

    protected List<String> basePrettierCommand() throws MojoExecutionException {
        Path nodeExecutable = this.resolveNodeExecutable();
        Path prettierJavaDirectory = this.extractPrettierJava();
        Path prettierBin = prettierJavaDirectory.resolve("prettier-java").resolve("node_modules").resolve("prettier").resolve("bin-prettier.js");
        Path prettierJavaPlugin = prettierJavaDirectory.resolve("prettier-java").resolve("node_modules").resolve("prettier-plugin-java");
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodeExecutable.toString());
        command.add(prettierBin.toString());
        command.add("--plugin=" + prettierJavaPlugin.toString());
        command.add("--color");
        if (this.printWidth != null) {
            command.add("--print-width");
            command.add(this.printWidth);
        }
        if (this.tabWidth != null) {
            command.add("--tab-width");
            command.add(this.tabWidth);
        }
        if (this.useTabs != null) {
            command.add("--use-tabs");
            command.add(this.useTabs.toString());
        }
        if (this.ignoreConfigFile) {
            command.add("--no-config");
        }
        if (this.ignoreEditorConfig) {
            command.add("--no-editorconfig");
        }
        return command;
    }

    private List<Path> determineInputPaths() {
        ArrayList inputPaths = new ArrayList();
        inputPaths.addAll(this.project.getCompileSourceRoots());
        inputPaths.addAll(this.project.getTestCompileSourceRoots());
        Path basePath = this.project.getBasedir().toPath();
        return inputPaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(basePath::relativize).collect(Collectors.toList());
    }

    private String computeGlob(List<Path> inputPaths) {
        String joinedPaths = inputPaths.size() > 1 ? inputPaths.stream().map(Path::toString).collect(Collectors.joining(",", "{", "}")) : inputPaths.get(0).toString();
        return joinedPaths + "/**/*.java";
    }
}

