/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.slimfast;

import com.hubspot.maven.plugins.slimfast.LocalArtifact;
import com.hubspot.maven.plugins.slimfast.LocalArtifactWrapper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.configuration.BeanConfigurationException;
import org.apache.maven.configuration.BeanConfigurationRequest;
import org.apache.maven.configuration.BeanConfigurator;
import org.apache.maven.configuration.DefaultBeanConfigurationRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public class ArtifactHelper {
    private static final List<String> ARTIFACT_EXPRESSION_PREFIXES = Collections.singletonList("artifact.");

    public static LocalArtifactWrapper getArtifactPaths(BeanConfigurator beanConfigurator, MavenProject project) throws MojoExecutionException {
        ManifestConfiguration manifestConfiguration = ArtifactHelper.parseManifestConfiguration(beanConfigurator, project);
        if (!manifestConfiguration.isAddClasspath()) {
            throw new MojoExecutionException("maven-jar-plugin is not configured to add classpath");
        }
        HashSet<LocalArtifact> artifacts = new HashSet<LocalArtifact>();
        for (String classpathElement : ArtifactHelper.classpathElements(project)) {
            File classpathFile = new File(classpathElement);
            if (!classpathFile.getAbsoluteFile().isFile()) continue;
            Artifact artifact = ArtifactHelper.findArtifactWithFile(project.getArtifacts(), classpathFile);
            Path localPath = classpathFile.toPath();
            Path targetPath = artifact == null || manifestConfiguration.getClasspathLayoutType() == null ? localPath.getFileName() : ArtifactHelper.computePath(artifact, manifestConfiguration);
            artifacts.add(new LocalArtifact(localPath, targetPath));
        }
        Path prefix = Paths.get("target", new String[0]).resolve(manifestConfiguration.getClasspathPrefix());
        return new LocalArtifactWrapper(prefix, artifacts);
    }

    private static ManifestConfiguration parseManifestConfiguration(BeanConfigurator beanConfigurator, MavenProject project) throws MojoExecutionException {
        MavenArchiveConfiguration archiveConfiguration = new MavenArchiveConfiguration();
        DefaultBeanConfigurationRequest beanConfiguration = new DefaultBeanConfigurationRequest().setBean((Object)archiveConfiguration).setConfiguration(project.getModel(), "org.apache.maven.plugins", "maven-jar-plugin", "default-jar");
        beanConfiguration.setConfiguration(beanConfiguration.getConfiguration(), "archive");
        try {
            beanConfigurator.configureBean((BeanConfigurationRequest)beanConfiguration);
        }
        catch (BeanConfigurationException e) {
            throw new MojoExecutionException("Error parsing archive configuration", (Exception)((Object)e));
        }
        return archiveConfiguration.getManifest();
    }

    private static List<String> classpathElements(MavenProject project) throws MojoExecutionException {
        try {
            return project.getRuntimeClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error resolving dependencies", (Exception)((Object)e));
        }
    }

    private static Path computePath(Artifact artifact, ManifestConfiguration config) throws MojoExecutionException {
        String layoutType = config.getClasspathLayoutType();
        String layout = config.getCustomClasspathLayout();
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        ArrayList<Object> valueSources = new ArrayList<Object>();
        valueSources.add(new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, (Object)artifact, true));
        valueSources.add(new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, (Object)artifact.getArtifactHandler(), true));
        Properties extraExpressions = new Properties();
        if (!artifact.isSnapshot()) {
            extraExpressions.setProperty("baseVersion", artifact.getVersion());
        }
        extraExpressions.setProperty("groupIdPath", artifact.getGroupId().replace('.', '/'));
        if (artifact.hasClassifier()) {
            extraExpressions.setProperty("dashClassifier", "-" + artifact.getClassifier());
            extraExpressions.setProperty("dashClassifier?", "-" + artifact.getClassifier());
        } else {
            extraExpressions.setProperty("dashClassifier", "");
            extraExpressions.setProperty("dashClassifier?", "");
        }
        valueSources.add(new PrefixedPropertiesValueSource(ARTIFACT_EXPRESSION_PREFIXES, extraExpressions, true));
        for (ValueSource valueSource : valueSources) {
            interpolator.addValueSource(valueSource);
        }
        PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(ARTIFACT_EXPRESSION_PREFIXES);
        try {
            String resolvedLayout;
            boolean bl = config.isUseUniqueVersions();
            switch (layoutType) {
                case "simple": {
                    resolvedLayout = bl ? "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}" : "${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
                    break;
                }
                case "repository": {
                    resolvedLayout = bl ? "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}" : "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
                    break;
                }
                case "custom": {
                    resolvedLayout = layout;
                    break;
                }
                default: {
                    throw new MojoExecutionException("Unknown classpath layout type: " + layoutType);
                }
            }
            return Paths.get(interpolator.interpolate(resolvedLayout, (RecursionInterceptor)recursionInterceptor), new String[0]);
        }
        catch (InterpolationException interpolationException) {
            throw new MojoExecutionException("Error computing path for classpath entry", (Exception)((Object)interpolationException));
        }
    }

    private static Artifact findArtifactWithFile(Set<Artifact> artifacts, File file) {
        for (Artifact artifact : artifacts) {
            if (!file.equals(artifact.getFile())) continue;
            return artifact;
        }
        return null;
    }
}

