/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.slimfast;

import com.hubspot.maven.plugins.slimfast.FileHelper;
import com.hubspot.maven.plugins.slimfast.FileUploader;
import com.hubspot.maven.plugins.slimfast.JsonHelper;
import com.hubspot.maven.plugins.slimfast.LocalArtifact;
import com.hubspot.maven.plugins.slimfast.S3Artifact;
import com.hubspot.maven.plugins.slimfast.S3ArtifactWrapper;
import com.hubspot.maven.plugins.slimfast.UploadConfiguration;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class BaseFileUploader
implements FileUploader {
    private Set<S3Artifact> s3Artifacts;
    private Path prefix;
    private Path outputFile;

    @Override
    public final void init(UploadConfiguration config, Log log) {
        this.s3Artifacts = Collections.synchronizedSet(new LinkedHashSet());
        this.prefix = config.getPrefix();
        this.outputFile = config.getOutputFile();
        this.doInit(config, log);
    }

    protected abstract void doUpload(String var1, String var2, Path var3) throws MojoFailureException, MojoExecutionException;

    protected void doInit(UploadConfiguration config, Log log) {
    }

    protected void doDestroy() throws MojoFailureException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void upload(UploadConfiguration config, LocalArtifact artifact) throws MojoExecutionException, MojoFailureException {
        String s3Key;
        String file = artifact.getTargetPath().toString();
        Path localPath = artifact.getLocalPath();
        boolean isUnresolvedSnapshot = file.toUpperCase().endsWith("-SNAPSHOT.JAR");
        if (isUnresolvedSnapshot) {
            if (!config.isAllowUnresolvedSnapshots()) throw new MojoExecutionException("Encountered unresolved snapshot: " + file);
            String start = file.substring(0, file.length() - ".JAR".length());
            String end = file.substring(file.length() - ".JAR".length());
            String md5 = FileHelper.md5(localPath);
            s3Key = Paths.get(config.getS3ArtifactRoot(), new String[0]).resolve(start + "-" + md5 + end).toString();
        } else {
            s3Key = Paths.get(config.getS3ArtifactRoot(), new String[0]).resolve(file).toString();
        }
        this.doUpload(config.getS3Bucket(), s3Key, localPath);
        String targetPath = this.prefix.resolve(artifact.getTargetPath()).toString();
        this.s3Artifacts.add(new S3Artifact(config.getS3Bucket(), s3Key, targetPath, FileHelper.md5(localPath), FileHelper.size(localPath)));
    }

    @Override
    public final void destroy() throws MojoFailureException {
        try {
            JsonHelper.writeArtifactsToJson(this.outputFile.toFile(), new S3ArtifactWrapper(this.prefix.toString(), this.s3Artifacts));
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing dependencies json to file", (Throwable)e);
        }
        this.doDestroy();
    }
}

