/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.slimfast;

import com.amazonaws.SdkBaseException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.hubspot.maven.plugins.slimfast.DownloadConfiguration;
import com.hubspot.maven.plugins.slimfast.FileDownloader;
import com.hubspot.maven.plugins.slimfast.FileHelper;
import com.hubspot.maven.plugins.slimfast.S3Artifact;
import com.hubspot.maven.plugins.slimfast.S3Factory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class DefaultFileDownloader
implements FileDownloader {
    private AmazonS3 s3Service;
    private Path cacheDirectory;
    private Log log;

    @Override
    public void init(DownloadConfiguration config, Log log) {
        this.s3Service = S3Factory.create(config.getS3AccessKey(), config.getS3SecretKey());
        this.cacheDirectory = config.getCacheDirectory();
        this.log = log;
    }

    @Override
    public void download(DownloadConfiguration config, S3Artifact artifact) throws MojoExecutionException, MojoFailureException {
        Path targetFile = config.getOutputDirectory().resolve(artifact.getTargetPath());
        if (this.artifactIsCached(targetFile, artifact)) {
            this.log.info((CharSequence)("Target file exists " + targetFile));
            return;
        }
        Path cacheFile = this.cacheDirectory.resolve(config.getPrefix().relativize(Paths.get(artifact.getTargetPath(), new String[0])));
        if (this.artifactIsCached(cacheFile, artifact)) {
            this.log.info((CharSequence)("Target file is cached " + cacheFile));
        } else {
            this.doDownload(artifact.getBucket(), artifact.getKey(), cacheFile);
            this.log.info((CharSequence)("Successfully downloaded key " + artifact.getKey()));
        }
        FileHelper.ensureDirectoryExists(targetFile.getParent());
        try {
            Files.copy(cacheFile, targetFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Error copying file from %s to %s", cacheFile, targetFile), (Throwable)e);
        }
        DefaultFileDownloader.verifyChecksums(targetFile, artifact);
    }

    @Override
    public void destroy() throws MojoExecutionException, MojoFailureException {
    }

    private boolean artifactIsCached(Path path, S3Artifact artifact) throws MojoExecutionException {
        return Files.exists(path, new LinkOption[0]) && DefaultFileDownloader.checksumsMatch(path, artifact);
    }

    private void doDownload(String bucket, String key, Path path) throws MojoFailureException, MojoExecutionException {
        Path tempPath = this.createTempFile(path);
        try {
            S3Object s3Object = this.s3Service.getObject(bucket, key);
            try (S3ObjectInputStream input = s3Object.getObjectContent();){
                Files.copy((InputStream)input, tempPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (SdkBaseException e) {
            throw new MojoFailureException("Error downloading key " + key, (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error downloading to file " + tempPath, (Throwable)e);
        }
        try {
            FileHelper.ensureDirectoryExists(path.getParent());
            Files.move(tempPath, path, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Error moving file from %s to %s", tempPath, path), (Throwable)e);
        }
    }

    private Path createTempFile(Path path) throws MojoFailureException {
        try {
            return Files.createTempFile(this.cacheDirectory, String.valueOf(path.getFileName()), null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error creating temp file in " + this.cacheDirectory, (Throwable)e);
        }
    }

    private static void verifyChecksums(Path path, S3Artifact artifact) throws MojoExecutionException {
        String expectedMd5;
        long expectedSize;
        long actualSize = FileHelper.size(path);
        if (actualSize != (expectedSize = artifact.getSize())) {
            throw new MojoExecutionException(String.format("File %s has unexpected size, expected=%s, actual=%s", path, expectedSize, actualSize));
        }
        String actualMd5 = FileHelper.md5(path);
        if (!actualMd5.equals(expectedMd5 = artifact.getMd5())) {
            throw new MojoExecutionException(String.format("File %s has unexpected checksum, expected=%s, actual=%s", path, expectedMd5, actualMd5));
        }
    }

    private static boolean checksumsMatch(Path path, S3Artifact artifact) throws MojoExecutionException {
        return FileHelper.size(path) == artifact.getSize() && FileHelper.md5(path).equals(artifact.getMd5());
    }
}

