/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.slimfast;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.hubspot.maven.plugins.slimfast.BaseFileUploader;
import com.hubspot.maven.plugins.slimfast.S3Factory;
import com.hubspot.maven.plugins.slimfast.UploadConfiguration;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class DefaultFileUploader
extends BaseFileUploader {
    private AmazonS3 s3Service;
    private Log log;

    @Override
    protected void doInit(UploadConfiguration config, Log log) {
        this.s3Service = S3Factory.create(config.getS3AccessKey(), config.getS3SecretKey());
        this.log = log;
    }

    @Override
    protected void doUpload(String bucket, String key, Path path) throws MojoFailureException, MojoExecutionException {
        if (this.keyExists(bucket, key)) {
            this.log.info((CharSequence)("Key already exists " + key));
            return;
        }
        try {
            this.s3Service.putObject(bucket, key, path.toFile());
            this.log.info((CharSequence)("Successfully uploaded key " + key));
        }
        catch (SdkClientException e) {
            throw new MojoFailureException("Error uploading file " + path, (Throwable)e);
        }
    }

    @Override
    protected void doDestroy() throws MojoFailureException {
    }

    private boolean keyExists(String bucket, String key) throws MojoFailureException {
        try {
            this.s3Service.getObjectMetadata(bucket, key);
            return true;
        }
        catch (SdkBaseException e) {
            if (e instanceof AmazonServiceException && ((AmazonServiceException)e).getStatusCode() == 404) {
                return false;
            }
            throw new MojoFailureException("Error getting object metadata for key " + key, (Throwable)e);
        }
    }
}

