/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.slimfast;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.maven.plugins.slimfast.DownloadConfiguration;
import com.hubspot.maven.plugins.slimfast.FileDownloader;
import com.hubspot.maven.plugins.slimfast.FileHelper;
import com.hubspot.maven.plugins.slimfast.JsonHelper;
import com.hubspot.maven.plugins.slimfast.S3Artifact;
import com.hubspot.maven.plugins.slimfast.S3ArtifactWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="download", requiresProject=false, threadSafe=true)
public class DownloadJarsMojo
extends AbstractMojo {
    @Parameter(property="slimfast.fileDownloader", alias="fileDownloader", defaultValue="com.hubspot.maven.plugins.slimfast.DefaultFileDownloader")
    private String fileDownloaderType;
    @Parameter(property="slimfast.s3.accessKey", defaultValue="${s3.access.key}", required=true)
    private String s3AccessKey;
    @Parameter(property="slimfast.s3.secretKey", defaultValue="${s3.secret.key}", required=true)
    private String s3SecretKey;
    @Parameter(property="slimfast.s3.downloadThreads", defaultValue="10")
    private int s3DownloadThreads;
    @Parameter(property="slimfast.cacheDirectory", defaultValue="${settings.localRepository}")
    private String cacheDirectory;
    @Parameter(property="slimfast.outputDirectory", defaultValue="${basedir}")
    private String outputDirectory;
    @Parameter(property="slimfast.inputFile", defaultValue="target/slimfast.json")
    private String inputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        S3ArtifactWrapper wrapper = this.readArtifactInfo();
        final DownloadConfiguration configuration = this.buildConfiguration(wrapper.getPrefix());
        FileHelper.ensureDirectoryExists(configuration.getCacheDirectory());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("slimfast-download").setDaemon(true).build();
        ExecutorService executor = Executors.newFixedThreadPool(this.s3DownloadThreads, threadFactory);
        final FileDownloader downloader = this.instantiateFileDownloader();
        downloader.init(configuration, this.getLog());
        ArrayList futures = new ArrayList();
        for (final S3Artifact artifact : wrapper.getArtifacts()) {
            futures.add(executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    downloader.download(configuration, artifact);
                    return null;
                }
            }));
        }
        executor.shutdown();
        this.waitForDownloadsToFinish(executor, futures);
        downloader.destroy();
    }

    private S3ArtifactWrapper readArtifactInfo() throws MojoFailureException {
        try {
            return JsonHelper.readArtifactsFromJson(new File(this.inputFile));
        }
        catch (IOException e) {
            throw new MojoFailureException("Error reading dependencies from file", (Throwable)e);
        }
    }

    private void waitForDownloadsToFinish(ExecutorService executor, List<Future<?>> futures) throws MojoExecutionException, MojoFailureException {
        try {
            if (!executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                this.getLog().error((CharSequence)"Took more than 5 minutes to download files, quitting");
                throw new MojoExecutionException("Took more than 5 minutes to download files");
            }
            for (Future<?> future : futures) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted", (Exception)e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), MojoExecutionException.class);
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), MojoFailureException.class);
            throw new MojoExecutionException("Unexpected exception", e.getCause());
        }
    }

    private DownloadConfiguration buildConfiguration(String prefix) {
        return new DownloadConfiguration(Paths.get(prefix, new String[0]), Paths.get(this.cacheDirectory, new String[0]), Paths.get(this.outputDirectory, new String[0]), this.s3AccessKey, this.s3SecretKey);
    }

    private FileDownloader instantiateFileDownloader() throws MojoExecutionException {
        try {
            return (FileDownloader)Class.forName(this.fileDownloaderType).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to find file downloader implementation", (Exception)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MojoExecutionException("Unable to instantiate file downloader", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException("Must implement FileDownloader interface", (Exception)e);
        }
    }
}

