/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.slimfast;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;

public class FileHelper {
    public static void ensureDirectoryExists(@Nullable Path path) throws MojoExecutionException {
        if (path != null && !Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating parent directories for path " + path, (Exception)e);
            }
        }
    }

    public static String md5(Path path) throws MojoExecutionException {
        try {
            return com.google.common.io.Files.hash((File)path.toFile(), (HashFunction)Hashing.md5()).toString();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file at path: " + path, (Exception)e);
        }
    }

    public static long size(Path path) throws MojoExecutionException {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file at path: " + path, (Exception)e);
        }
    }
}

