/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.slimfast;

import com.hubspot.maven.plugins.slimfast.S3Artifact;
import com.hubspot.maven.plugins.slimfast.S3ArtifactWrapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonHelper {
    public static void writeArtifactsToJson(File outputFile, S3ArtifactWrapper wrapper) throws IOException {
        JSONObject json = new JSONObject();
        JSONArray artifacts = new JSONArray();
        for (S3Artifact artifact : wrapper.getArtifacts()) {
            artifacts.add((Object)JsonHelper.toJsonObject(artifact));
        }
        json.put((Object)"prefix", (Object)wrapper.getPrefix());
        json.put((Object)"artifacts", (Object)artifacts);
        try (Writer writer = JsonHelper.newWriter(outputFile);){
            json.writeJSONString(writer);
            writer.flush();
        }
    }

    public static S3ArtifactWrapper readArtifactsFromJson(File inputFile) throws IOException {
        JSONParser parser = new JSONParser();
        Throwable throwable = null;
        try (Reader reader = JsonHelper.newReader(inputFile);){
            JSONObject parsed = (JSONObject)parser.parse(reader);
            String prefix = (String)parsed.get((Object)"prefix");
            LinkedHashSet<S3Artifact> artifacts = new LinkedHashSet<S3Artifact>();
            for (Object object : (JSONArray)parsed.get((Object)"artifacts")) {
                artifacts.add(JsonHelper.fromJsonObject((JSONObject)object));
            }
            S3ArtifactWrapper s3ArtifactWrapper = new S3ArtifactWrapper(prefix, artifacts);
            return s3ArtifactWrapper;
        }
        catch (ParseException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static Writer newWriter(File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));
    }

    private static Reader newReader(File file) throws IOException {
        FileInputStream outputStream = new FileInputStream(file);
        return new BufferedReader(new InputStreamReader((InputStream)outputStream, StandardCharsets.UTF_8));
    }

    private static JSONObject toJsonObject(S3Artifact artifact) {
        JSONObject json = new JSONObject();
        json.put((Object)"s3Bucket", (Object)artifact.getBucket());
        json.put((Object)"s3ObjectKey", (Object)artifact.getKey());
        json.put((Object)"targetPath", (Object)artifact.getTargetPath());
        json.put((Object)"md5", (Object)artifact.getMd5());
        json.put((Object)"filesize", (Object)artifact.getSize());
        return json;
    }

    private static S3Artifact fromJsonObject(JSONObject json) {
        String bucket = (String)json.get((Object)"s3Bucket");
        String key = (String)json.get((Object)"s3ObjectKey");
        String targetPath = (String)json.get((Object)"targetPath");
        String md5 = (String)json.get((Object)"md5");
        long size = ((Number)json.get((Object)"filesize")).longValue();
        return new S3Artifact(bucket, key, targetPath, md5, size);
    }
}

