/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.slimfast;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.maven.plugins.slimfast.ArtifactHelper;
import com.hubspot.maven.plugins.slimfast.FileHelper;
import com.hubspot.maven.plugins.slimfast.FileUploader;
import com.hubspot.maven.plugins.slimfast.LocalArtifact;
import com.hubspot.maven.plugins.slimfast.LocalArtifactWrapper;
import com.hubspot.maven.plugins.slimfast.UploadConfiguration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.maven.configuration.BeanConfigurator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class UploadJarsMojo
extends AbstractMojo {
    private static final String DEFAULT_UPLOADER = "com.hubspot.maven.plugins.slimfast.DefaultFileUploader";
    private static final String DRY_RUN_UPLOADER = "com.hubspot.maven.plugins.slimfast.DryRunFileUploader";
    @Component
    private BeanConfigurator beanConfigurator;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="slimfast.fileUploader", alias="fileUploader", defaultValue="com.hubspot.maven.plugins.slimfast.DefaultFileUploader")
    private String fileUploaderType;
    @Parameter(property="slimfast.s3.bucket", defaultValue="${s3.bucket}", required=true)
    private String s3Bucket;
    @Parameter(property="slimfast.s3.artifactPrefix", defaultValue="${s3.artifact.root}", required=true)
    private String s3ArtifactRoot;
    @Parameter(property="slimfast.s3.accessKey", defaultValue="${s3.access.key}", required=true)
    private String s3AccessKey;
    @Parameter(property="slimfast.s3.secretKey", defaultValue="${s3.secret.key}", required=true)
    private String s3SecretKey;
    @Parameter(property="slimfast.s3.uploadThreads", defaultValue="10")
    private int s3UploadThreads;
    @Parameter(property="slimfast.repositoryPath", defaultValue="${settings.localRepository}")
    private String repositoryPath;
    @Parameter(property="slimfast.plugin.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="slimfast.outputFile", defaultValue="${project.build.directory}/slimfast.json")
    private String outputFile;
    @Parameter(property="slimfast.allowUnresolvedSnapshots", defaultValue="false")
    private boolean allowUnresolvedSnapshots;
    @Parameter(property="slimfast.dryRun", defaultValue="false")
    private boolean dryRun;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        LocalArtifactWrapper artifactWrapper = ArtifactHelper.getArtifactPaths(this.beanConfigurator, this.project);
        final UploadConfiguration configuration = this.buildConfiguration(artifactWrapper.getPrefix());
        FileHelper.ensureDirectoryExists(configuration.getOutputFile().getParent());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("slimfast-upload").setDaemon(true).build();
        ExecutorService executor = Executors.newFixedThreadPool(this.s3UploadThreads, threadFactory);
        final FileUploader uploader = this.instantiateFileUploader();
        uploader.init(configuration, this.getLog());
        ArrayList futures = new ArrayList();
        for (final LocalArtifact artifact : artifactWrapper.getArtifacts()) {
            futures.add(executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    uploader.upload(configuration, artifact);
                    return null;
                }
            }));
        }
        executor.shutdown();
        this.waitForUploadsToFinish(executor, futures);
        uploader.destroy();
    }

    private void waitForUploadsToFinish(ExecutorService executor, List<Future<?>> futures) throws MojoExecutionException, MojoFailureException {
        try {
            if (!executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                this.getLog().error((CharSequence)"Took more than 5 minutes to upload files, quitting");
                throw new MojoExecutionException("Took more than 5 minutes to upload files");
            }
            for (Future<?> future : futures) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted", (Exception)e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), MojoExecutionException.class);
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), MojoFailureException.class);
            throw new MojoExecutionException("Unexpected exception", e.getCause());
        }
    }

    private UploadConfiguration buildConfiguration(Path prefix) {
        return new UploadConfiguration(prefix, this.s3Bucket, this.s3ArtifactRoot, this.s3AccessKey, this.s3SecretKey, Paths.get(this.outputFile, new String[0]), this.allowUnresolvedSnapshots);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FileUploader instantiateFileUploader() throws MojoExecutionException {
        String resolvedFileUploaderType;
        if (this.dryRun) {
            if (!DEFAULT_UPLOADER.equals(this.fileUploaderType)) throw new MojoExecutionException("May not specify custom fileUploader when using the dryRun flag");
            resolvedFileUploaderType = DRY_RUN_UPLOADER;
        } else {
            resolvedFileUploaderType = this.fileUploaderType;
        }
        try {
            return (FileUploader)Class.forName(resolvedFileUploaderType).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to find file uploader implementation", (Exception)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MojoExecutionException("Unable to instantiate file uploader", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException("Must implement FileUploader interface", (Exception)e);
        }
    }
}

