/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.channels.PagingDirection;
import java.util.Optional;
import org.immutables.value.Value;

public interface TimeIntervalFilter {
    @JsonProperty(value="inclusive")
    public Optional<Boolean> isInclusive();

    @JsonProperty(value="latest")
    public Optional<String> getNewestTimestamp();

    @JsonProperty(value="oldest")
    public Optional<String> getOldestTimestamp();

    @JsonIgnore
    @Value.Derived
    default public PagingDirection getPagingDirection() {
        if (this.getOldestTimestamp().isPresent() && !this.getNewestTimestamp().isPresent()) {
            return PagingDirection.FORWARD_IN_TIME;
        }
        return PagingDirection.BACKWARD_IN_TIME;
    }
}

