/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.AbstractChatMessageParams;
import com.hubspot.slack.client.methods.params.chat.AbstractSlashCommandResponseParams;
import com.hubspot.slack.client.methods.params.chat.MessageParams;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.TopLevelMessageResponseType;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlashCommandResponseParams
extends AbstractSlashCommandResponseParams {
    private final TopLevelMessageResponseType responseType;
    private final String channelId;
    @Nullable
    private final String text;
    @Nullable
    private final String threadTs;
    @Nullable
    private final String username;
    @Nullable
    private final Boolean asUser;
    @Nullable
    private final String iconEmoji;
    @Nullable
    private final String iconUrl;
    @Nullable
    private final Boolean linkNames;
    @Nullable
    private final Boolean unfurlLinks;
    @Nullable
    private final Boolean unfurlMedia;
    @Nullable
    private final Boolean replyBroadcast;
    private final List<Attachment> attachments;
    private final List<Block> blocks;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlashCommandResponseParams(Builder builder) {
        this.channelId = builder.channelId;
        this.text = builder.text;
        this.threadTs = builder.threadTs;
        this.username = builder.username;
        this.asUser = builder.asUser;
        this.iconEmoji = builder.iconEmoji;
        this.iconUrl = builder.iconUrl;
        this.linkNames = builder.linkNames;
        this.unfurlLinks = builder.unfurlLinks;
        this.unfurlMedia = builder.unfurlMedia;
        this.replyBroadcast = builder.replyBroadcast;
        this.attachments = SlashCommandResponseParams.createUnmodifiableList(true, builder.attachments);
        if (builder.responseType != null) {
            this.initShim.setResponseType(builder.responseType);
        }
        if (builder.blocksIsSet()) {
            this.initShim.setBlocks(SlashCommandResponseParams.createUnmodifiableList(true, builder.blocks));
        }
        this.responseType = this.initShim.getResponseType();
        this.blocks = this.initShim.getBlocks();
        this.initShim = null;
    }

    private SlashCommandResponseParams(TopLevelMessageResponseType responseType, String channelId, @Nullable String text, @Nullable String threadTs, @Nullable String username, @Nullable Boolean asUser, @Nullable String iconEmoji, @Nullable String iconUrl, @Nullable Boolean linkNames, @Nullable Boolean unfurlLinks, @Nullable Boolean unfurlMedia, @Nullable Boolean replyBroadcast, List<Attachment> attachments, List<Block> blocks) {
        this.responseType = responseType;
        this.channelId = channelId;
        this.text = text;
        this.threadTs = threadTs;
        this.username = username;
        this.asUser = asUser;
        this.iconEmoji = iconEmoji;
        this.iconUrl = iconUrl;
        this.linkNames = linkNames;
        this.unfurlLinks = unfurlLinks;
        this.unfurlMedia = unfurlMedia;
        this.replyBroadcast = replyBroadcast;
        this.attachments = attachments;
        this.blocks = blocks;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public TopLevelMessageResponseType getResponseType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getResponseType() : this.responseType;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Boolean> getAsUser() {
        return Optional.ofNullable(this.asUser);
    }

    @Override
    @JsonProperty
    public Optional<String> getIconEmoji() {
        return Optional.ofNullable(this.iconEmoji);
    }

    @Override
    @JsonProperty
    public Optional<String> getIconUrl() {
        return Optional.ofNullable(this.iconUrl);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getLinkNames() {
        return Optional.ofNullable(this.linkNames);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getUnfurlLinks() {
        return Optional.ofNullable(this.unfurlLinks);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getUnfurlMedia() {
        return Optional.ofNullable(this.unfurlMedia);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getReplyBroadcast() {
        return Optional.ofNullable(this.replyBroadcast);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBlocks() : this.blocks;
    }

    public final SlashCommandResponseParams withResponseType(TopLevelMessageResponseType responseType) {
        if (this.responseType == responseType) {
            return this;
        }
        TopLevelMessageResponseType newValue = Objects.requireNonNull(responseType, "responseType");
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(newValue, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, newValue, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, newValue, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, value, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, newValue, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, value, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withUsername(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, newValue, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, value, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withAsUser(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.asUser, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, newValue, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withAsUser(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.asUser, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, value, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withIconEmoji(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.iconEmoji, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, newValue, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withIconEmoji(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.iconEmoji, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, value, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withIconUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.iconUrl, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, newValue, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withIconUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.iconUrl, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, value, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withLinkNames(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.linkNames, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, newValue, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withLinkNames(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.linkNames, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, value, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withUnfurlLinks(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.unfurlLinks, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, newValue, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withUnfurlLinks(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.unfurlLinks, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, value, this.unfurlMedia, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withUnfurlMedia(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.unfurlMedia, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, newValue, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withUnfurlMedia(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.unfurlMedia, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, value, this.replyBroadcast, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withReplyBroadcast(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.replyBroadcast, newValue)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, newValue, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withReplyBroadcast(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.replyBroadcast, value)) {
            return this;
        }
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, value, this.attachments, this.blocks));
    }

    public final SlashCommandResponseParams withAttachments(Attachment ... elements) {
        List<Attachment> newValue = SlashCommandResponseParams.createUnmodifiableList(false, SlashCommandResponseParams.createSafeList(Arrays.asList(elements), true, false));
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, newValue, this.blocks));
    }

    public final SlashCommandResponseParams withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = SlashCommandResponseParams.createUnmodifiableList(false, SlashCommandResponseParams.createSafeList(elements, true, false));
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, newValue, this.blocks));
    }

    public final SlashCommandResponseParams withBlocks(Block ... elements) {
        List<Block> newValue = SlashCommandResponseParams.createUnmodifiableList(false, SlashCommandResponseParams.createSafeList(Arrays.asList(elements), true, false));
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, newValue));
    }

    public final SlashCommandResponseParams withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = SlashCommandResponseParams.createUnmodifiableList(false, SlashCommandResponseParams.createSafeList(elements, true, false));
        return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this.responseType, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast, this.attachments, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlashCommandResponseParams && this.equalTo((SlashCommandResponseParams)another);
    }

    private boolean equalTo(SlashCommandResponseParams another) {
        return this.responseType.equals((Object)another.responseType) && this.channelId.equals(another.channelId) && Objects.equals(this.text, another.text) && Objects.equals(this.threadTs, another.threadTs) && Objects.equals(this.username, another.username) && Objects.equals(this.asUser, another.asUser) && Objects.equals(this.iconEmoji, another.iconEmoji) && Objects.equals(this.iconUrl, another.iconUrl) && Objects.equals(this.linkNames, another.linkNames) && Objects.equals(this.unfurlLinks, another.unfurlLinks) && Objects.equals(this.unfurlMedia, another.unfurlMedia) && Objects.equals(this.replyBroadcast, another.replyBroadcast) && this.attachments.equals(another.attachments) && this.blocks.equals(another.blocks);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.responseType.hashCode();
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + Objects.hashCode(this.text);
        h = h * 17 + Objects.hashCode(this.threadTs);
        h = h * 17 + Objects.hashCode(this.username);
        h = h * 17 + Objects.hashCode(this.asUser);
        h = h * 17 + Objects.hashCode(this.iconEmoji);
        h = h * 17 + Objects.hashCode(this.iconUrl);
        h = h * 17 + Objects.hashCode(this.linkNames);
        h = h * 17 + Objects.hashCode(this.unfurlLinks);
        h = h * 17 + Objects.hashCode(this.unfurlMedia);
        h = h * 17 + Objects.hashCode(this.replyBroadcast);
        h = h * 17 + this.attachments.hashCode();
        h = h * 17 + this.blocks.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlashCommandResponseParams{");
        builder.append("responseType=").append((Object)this.responseType);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        if (this.text != null) {
            builder.append(", ");
            builder.append("text=").append(this.text);
        }
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        if (this.asUser != null) {
            builder.append(", ");
            builder.append("asUser=").append(this.asUser);
        }
        if (this.iconEmoji != null) {
            builder.append(", ");
            builder.append("iconEmoji=").append(this.iconEmoji);
        }
        if (this.iconUrl != null) {
            builder.append(", ");
            builder.append("iconUrl=").append(this.iconUrl);
        }
        if (this.linkNames != null) {
            builder.append(", ");
            builder.append("linkNames=").append(this.linkNames);
        }
        if (this.unfurlLinks != null) {
            builder.append(", ");
            builder.append("unfurlLinks=").append(this.unfurlLinks);
        }
        if (this.unfurlMedia != null) {
            builder.append(", ");
            builder.append("unfurlMedia=").append(this.unfurlMedia);
        }
        if (this.replyBroadcast != null) {
            builder.append(", ");
            builder.append("replyBroadcast=").append(this.replyBroadcast);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlashCommandResponseParams fromJson(Json json) {
        Builder builder = SlashCommandResponseParams.builder();
        if (json.responseType != null) {
            builder.setResponseType(json.responseType);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.asUser != null) {
            builder.setAsUser(json.asUser);
        }
        if (json.iconEmoji != null) {
            builder.setIconEmoji(json.iconEmoji);
        }
        if (json.iconUrl != null) {
            builder.setIconUrl(json.iconUrl);
        }
        if (json.linkNames != null) {
            builder.setLinkNames(json.linkNames);
        }
        if (json.unfurlLinks != null) {
            builder.setUnfurlLinks(json.unfurlLinks);
        }
        if (json.unfurlMedia != null) {
            builder.setUnfurlMedia(json.unfurlMedia);
        }
        if (json.replyBroadcast != null) {
            builder.setReplyBroadcast(json.replyBroadcast);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.blocksIsSet) {
            builder.setBlocks(json.blocks);
        }
        return builder.build();
    }

    private static SlashCommandResponseParams validate(SlashCommandResponseParams instance) {
        instance.check();
        return instance;
    }

    public static SlashCommandResponseParams copyOf(AbstractSlashCommandResponseParams instance) {
        if (instance instanceof SlashCommandResponseParams) {
            return (SlashCommandResponseParams)instance;
        }
        return SlashCommandResponseParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long OPT_BIT_BLOCKS = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private TopLevelMessageResponseType responseType;
        @Nullable
        private String channelId;
        @Nullable
        private String text;
        @Nullable
        private String threadTs;
        @Nullable
        private String username;
        @Nullable
        private Boolean asUser;
        @Nullable
        private String iconEmoji;
        @Nullable
        private String iconUrl;
        @Nullable
        private Boolean linkNames;
        @Nullable
        private Boolean unfurlLinks;
        @Nullable
        private Boolean unfurlMedia;
        @Nullable
        private Boolean replyBroadcast;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private List<Block> blocks = new ArrayList<Block>();

        private Builder() {
        }

        public final Builder from(MessageParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSlashCommandResponseParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractChatMessageParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof MessageParams) {
                instance = (MessageParams)object;
                this.addAllBlocks(instance.getBlocks());
                this.addAllAttachments(instance.getAttachments());
                if ((bits & 1L) == 0L) {
                    Optional<String> textOptional = instance.getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractSlashCommandResponseParams) {
                instance = (AbstractSlashCommandResponseParams)object;
                this.setResponseType(((AbstractSlashCommandResponseParams)instance).getResponseType());
            }
            if (object instanceof AbstractChatMessageParams) {
                Optional<String> usernameOptional;
                Optional<Boolean> asUserOptional;
                Optional<String> threadTsOptional;
                Optional<String> iconUrlOptional;
                Optional<Boolean> linkNamesOptional;
                Optional<Boolean> replyBroadcastOptional;
                Optional<Boolean> unfurlLinksOptional;
                Optional<String> iconEmojiOptional;
                instance = (AbstractChatMessageParams)object;
                Optional<Boolean> unfurlMediaOptional = ((AbstractChatMessageParams)instance).getUnfurlMedia();
                if (unfurlMediaOptional.isPresent()) {
                    this.setUnfurlMedia(unfurlMediaOptional);
                }
                if ((iconEmojiOptional = ((AbstractChatMessageParams)instance).getIconEmoji()).isPresent()) {
                    this.setIconEmoji(iconEmojiOptional);
                }
                if ((unfurlLinksOptional = ((AbstractChatMessageParams)instance).getUnfurlLinks()).isPresent()) {
                    this.setUnfurlLinks(unfurlLinksOptional);
                }
                if ((replyBroadcastOptional = ((AbstractChatMessageParams)instance).getReplyBroadcast()).isPresent()) {
                    this.setReplyBroadcast(replyBroadcastOptional);
                }
                if ((linkNamesOptional = ((AbstractChatMessageParams)instance).getLinkNames()).isPresent()) {
                    this.setLinkNames(linkNamesOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> textOptional = ((AbstractChatMessageParams)instance).getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 1L;
                }
                if ((iconUrlOptional = ((AbstractChatMessageParams)instance).getIconUrl()).isPresent()) {
                    this.setIconUrl(iconUrlOptional);
                }
                if ((threadTsOptional = ((AbstractChatMessageParams)instance).getThreadTs()).isPresent()) {
                    this.setThreadTs(threadTsOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(((AbstractChatMessageParams)instance).getChannelId());
                    bits |= 2L;
                }
                if ((asUserOptional = ((AbstractChatMessageParams)instance).getAsUser()).isPresent()) {
                    this.setAsUser(asUserOptional);
                }
                if ((usernameOptional = ((AbstractChatMessageParams)instance).getUsername()).isPresent()) {
                    this.setUsername(usernameOptional);
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
        }

        public final Builder setResponseType(TopLevelMessageResponseType responseType) {
            this.responseType = Objects.requireNonNull(responseType, "responseType");
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder setUsername(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public final Builder setAsUser(@Nullable Boolean asUser) {
            this.asUser = asUser;
            return this;
        }

        public final Builder setAsUser(Optional<Boolean> asUser) {
            this.asUser = asUser.orElse(null);
            return this;
        }

        public final Builder setIconEmoji(@Nullable String iconEmoji) {
            this.iconEmoji = iconEmoji;
            return this;
        }

        public final Builder setIconEmoji(Optional<String> iconEmoji) {
            this.iconEmoji = iconEmoji.orElse(null);
            return this;
        }

        public final Builder setIconUrl(@Nullable String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final Builder setIconUrl(Optional<String> iconUrl) {
            this.iconUrl = iconUrl.orElse(null);
            return this;
        }

        public final Builder setLinkNames(@Nullable Boolean linkNames) {
            this.linkNames = linkNames;
            return this;
        }

        public final Builder setLinkNames(Optional<Boolean> linkNames) {
            this.linkNames = linkNames.orElse(null);
            return this;
        }

        public final Builder setUnfurlLinks(@Nullable Boolean unfurlLinks) {
            this.unfurlLinks = unfurlLinks;
            return this;
        }

        public final Builder setUnfurlLinks(Optional<Boolean> unfurlLinks) {
            this.unfurlLinks = unfurlLinks.orElse(null);
            return this;
        }

        public final Builder setUnfurlMedia(@Nullable Boolean unfurlMedia) {
            this.unfurlMedia = unfurlMedia;
            return this;
        }

        public final Builder setUnfurlMedia(Optional<Boolean> unfurlMedia) {
            this.unfurlMedia = unfurlMedia.orElse(null);
            return this;
        }

        public final Builder setReplyBroadcast(@Nullable Boolean replyBroadcast) {
            this.replyBroadcast = replyBroadcast;
            return this;
        }

        public final Builder setReplyBroadcast(Optional<Boolean> replyBroadcast) {
            this.replyBroadcast = replyBroadcast.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public SlashCommandResponseParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this));
        }

        private boolean blocksIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build SlashCommandResponseParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractSlashCommandResponseParams {
        @Nullable
        TopLevelMessageResponseType responseType;
        @Nullable
        String channelId;
        Optional<String> text = Optional.empty();
        Optional<String> threadTs = Optional.empty();
        Optional<String> username = Optional.empty();
        Optional<Boolean> asUser = Optional.empty();
        Optional<String> iconEmoji = Optional.empty();
        Optional<String> iconUrl = Optional.empty();
        Optional<Boolean> linkNames = Optional.empty();
        Optional<Boolean> unfurlLinks = Optional.empty();
        Optional<Boolean> unfurlMedia = Optional.empty();
        Optional<Boolean> replyBroadcast = Optional.empty();
        List<Attachment> attachments = Collections.emptyList();
        List<Block> blocks = Collections.emptyList();
        boolean blocksIsSet;

        Json() {
        }

        @JsonProperty
        public void setResponseType(TopLevelMessageResponseType responseType) {
            this.responseType = responseType;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public void setAsUser(Optional<Boolean> asUser) {
            this.asUser = asUser;
        }

        @JsonProperty
        public void setIconEmoji(Optional<String> iconEmoji) {
            this.iconEmoji = iconEmoji;
        }

        @JsonProperty
        public void setIconUrl(Optional<String> iconUrl) {
            this.iconUrl = iconUrl;
        }

        @JsonProperty
        public void setLinkNames(Optional<Boolean> linkNames) {
            this.linkNames = linkNames;
        }

        @JsonProperty
        public void setUnfurlLinks(Optional<Boolean> unfurlLinks) {
            this.unfurlLinks = unfurlLinks;
        }

        @JsonProperty
        public void setUnfurlMedia(Optional<Boolean> unfurlMedia) {
            this.unfurlMedia = unfurlMedia;
        }

        @JsonProperty
        public void setReplyBroadcast(Optional<Boolean> replyBroadcast) {
            this.replyBroadcast = replyBroadcast;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksIsSet = true;
        }

        @Override
        public TopLevelMessageResponseType getResponseType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getAsUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getIconEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getIconUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getLinkNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getUnfurlLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getUnfurlMedia() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getReplyBroadcast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private TopLevelMessageResponseType responseType;
        private int responseTypeStage;
        private List<Block> blocks;
        private int blocksStage;

        private InitShim() {
        }

        TopLevelMessageResponseType getResponseType() {
            if (this.responseTypeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.responseTypeStage == 0) {
                this.responseTypeStage = -1;
                this.responseType = Objects.requireNonNull(SlashCommandResponseParams.super.getResponseType(), "responseType");
                this.responseTypeStage = 1;
            }
            return this.responseType;
        }

        void setResponseType(TopLevelMessageResponseType responseType) {
            this.responseType = responseType;
            this.responseTypeStage = 1;
        }

        List<Block> getBlocks() {
            if (this.blocksStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.blocksStage == 0) {
                this.blocksStage = -1;
                this.blocks = SlashCommandResponseParams.createUnmodifiableList(false, SlashCommandResponseParams.createSafeList(SlashCommandResponseParams.super.getBlocks(), true, false));
                this.blocksStage = 1;
            }
            return this.blocks;
        }

        void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.responseTypeStage == -1) {
                attributes.add("responseType");
            }
            if (this.blocksStage == -1) {
                attributes.add("blocks");
            }
            return "Cannot build SlashCommandResponseParams, attribute initializers form cycle" + attributes;
        }
    }
}

