/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.TimeIntervalFilter;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.channels.PagingDirection;
import com.hubspot.slack.client.methods.params.conversations.AbstractConversationHistoryPagedParams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationHistoryPagedParams
extends AbstractConversationHistoryPagedParams {
    private final String channelId;
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer limit;
    @Nullable
    private final Boolean inclusive;
    @Nullable
    private final String newestTimestamp;
    @Nullable
    private final String oldestTimestamp;
    private final PagingDirection pagingDirection;

    private ConversationHistoryPagedParams(String channelId, @Nullable String cursor, @Nullable Integer limit, @Nullable Boolean inclusive, @Nullable String newestTimestamp, @Nullable String oldestTimestamp) {
        this.channelId = channelId;
        this.cursor = cursor;
        this.limit = limit;
        this.inclusive = inclusive;
        this.newestTimestamp = newestTimestamp;
        this.oldestTimestamp = oldestTimestamp;
        this.pagingDirection = Objects.requireNonNull(super.getPagingDirection(), "pagingDirection");
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getCursor() {
        return Optional.ofNullable(this.cursor);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="inclusive")
    public Optional<Boolean> isInclusive() {
        return Optional.ofNullable(this.inclusive);
    }

    @Override
    @JsonProperty(value="latest")
    public Optional<String> getNewestTimestamp() {
        return Optional.ofNullable(this.newestTimestamp);
    }

    @Override
    @JsonProperty(value="oldest")
    public Optional<String> getOldestTimestamp() {
        return Optional.ofNullable(this.oldestTimestamp);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public PagingDirection getPagingDirection() {
        return this.pagingDirection;
    }

    public final ConversationHistoryPagedParams withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new ConversationHistoryPagedParams(newValue, this.cursor, this.limit, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withCursor(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.cursor, newValue)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, newValue, this.limit, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withCursor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.cursor, value)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, value, this.limit, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withLimit(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, this.cursor, newValue, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withLimit(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, this.cursor, value, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withInclusive(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.inclusive, newValue)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, newValue, this.newestTimestamp, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withInclusive(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.inclusive, value)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, value, this.newestTimestamp, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withNewestTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.newestTimestamp, newValue)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, newValue, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withNewestTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.newestTimestamp, value)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, value, this.oldestTimestamp);
    }

    public final ConversationHistoryPagedParams withOldestTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.oldestTimestamp, newValue)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, this.newestTimestamp, newValue);
    }

    public final ConversationHistoryPagedParams withOldestTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.oldestTimestamp, value)) {
            return this;
        }
        return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, this.newestTimestamp, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationHistoryPagedParams && this.equalTo((ConversationHistoryPagedParams)another);
    }

    private boolean equalTo(ConversationHistoryPagedParams another) {
        return this.channelId.equals(another.channelId) && Objects.equals(this.cursor, another.cursor) && Objects.equals(this.limit, another.limit) && Objects.equals(this.inclusive, another.inclusive) && Objects.equals(this.newestTimestamp, another.newestTimestamp) && Objects.equals(this.oldestTimestamp, another.oldestTimestamp) && this.pagingDirection.equals((Object)another.pagingDirection);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + Objects.hashCode(this.cursor);
        h = h * 17 + Objects.hashCode(this.limit);
        h = h * 17 + Objects.hashCode(this.inclusive);
        h = h * 17 + Objects.hashCode(this.newestTimestamp);
        h = h * 17 + Objects.hashCode(this.oldestTimestamp);
        h = h * 17 + this.pagingDirection.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationHistoryPagedParams{");
        builder.append("channelId=").append(this.channelId);
        if (this.cursor != null) {
            builder.append(", ");
            builder.append("cursor=").append(this.cursor);
        }
        if (this.limit != null) {
            builder.append(", ");
            builder.append("limit=").append(this.limit);
        }
        if (this.inclusive != null) {
            builder.append(", ");
            builder.append("inclusive=").append(this.inclusive);
        }
        if (this.newestTimestamp != null) {
            builder.append(", ");
            builder.append("newestTimestamp=").append(this.newestTimestamp);
        }
        if (this.oldestTimestamp != null) {
            builder.append(", ");
            builder.append("oldestTimestamp=").append(this.oldestTimestamp);
        }
        builder.append(", ");
        builder.append("pagingDirection=").append((Object)this.pagingDirection);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ConversationHistoryPagedParams fromJson(Json json) {
        Builder builder = ConversationHistoryPagedParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.cursor != null) {
            builder.setCursor(json.cursor);
        }
        if (json.limit != null) {
            builder.setLimit(json.limit);
        }
        if (json.inclusive != null) {
            builder.setInclusive(json.inclusive);
        }
        if (json.newestTimestamp != null) {
            builder.setNewestTimestamp(json.newestTimestamp);
        }
        if (json.oldestTimestamp != null) {
            builder.setOldestTimestamp(json.oldestTimestamp);
        }
        return builder.build();
    }

    public static ConversationHistoryPagedParams copyOf(AbstractConversationHistoryPagedParams instance) {
        if (instance instanceof ConversationHistoryPagedParams) {
            return (ConversationHistoryPagedParams)instance;
        }
        return ConversationHistoryPagedParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String channelId;
        @Nullable
        private String cursor;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean inclusive;
        @Nullable
        private String newestTimestamp;
        @Nullable
        private String oldestTimestamp;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TimeIntervalFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractConversationHistoryPagedParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof TimeIntervalFilter) {
                Optional<String> newestTimestampOptional;
                Optional<Boolean> inclusiveOptional;
                instance = (TimeIntervalFilter)object;
                Optional<String> oldestTimestampOptional = instance.getOldestTimestamp();
                if (oldestTimestampOptional.isPresent()) {
                    this.setOldestTimestamp(oldestTimestampOptional);
                }
                if ((inclusiveOptional = instance.isInclusive()).isPresent()) {
                    this.setInclusive(inclusiveOptional);
                }
                if ((newestTimestampOptional = instance.getNewestTimestamp()).isPresent()) {
                    this.setNewestTimestamp(newestTimestampOptional);
                }
            }
            if (object instanceof AbstractConversationHistoryPagedParams) {
                Optional<Integer> limitOptional;
                instance = (AbstractConversationHistoryPagedParams)object;
                Optional<String> cursorOptional = ((AbstractConversationHistoryPagedParams)instance).getCursor();
                if (cursorOptional.isPresent()) {
                    this.setCursor(cursorOptional);
                }
                if ((limitOptional = ((AbstractConversationHistoryPagedParams)instance).getLimit()).isPresent()) {
                    this.setLimit(limitOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setChannelId(((AbstractConversationHistoryPagedParams)instance).getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCursor(@Nullable String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final Builder setCursor(Optional<String> cursor) {
            this.cursor = cursor.orElse(null);
            return this;
        }

        public final Builder setLimit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Builder setLimit(Optional<Integer> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        public final Builder setInclusive(@Nullable Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public final Builder setInclusive(Optional<Boolean> inclusive) {
            this.inclusive = inclusive.orElse(null);
            return this;
        }

        public final Builder setNewestTimestamp(@Nullable String newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
            return this;
        }

        public final Builder setNewestTimestamp(Optional<String> newestTimestamp) {
            this.newestTimestamp = newestTimestamp.orElse(null);
            return this;
        }

        public final Builder setOldestTimestamp(@Nullable String oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
            return this;
        }

        public final Builder setOldestTimestamp(Optional<String> oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp.orElse(null);
            return this;
        }

        public ConversationHistoryPagedParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ConversationHistoryPagedParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractConversationHistoryPagedParams {
        @Nullable
        String channelId;
        Optional<String> cursor = Optional.empty();
        Optional<Integer> limit = Optional.empty();
        Optional<Boolean> inclusive = Optional.empty();
        Optional<String> newestTimestamp = Optional.empty();
        Optional<String> oldestTimestamp = Optional.empty();

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setCursor(Optional<String> cursor) {
            this.cursor = cursor;
        }

        @JsonProperty
        public void setLimit(Optional<Integer> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="inclusive")
        public void setInclusive(Optional<Boolean> inclusive) {
            this.inclusive = inclusive;
        }

        @JsonProperty(value="latest")
        public void setNewestTimestamp(Optional<String> newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
        }

        @JsonProperty(value="oldest")
        public void setOldestTimestamp(Optional<String> oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getLimit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isInclusive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNewestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOldestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PagingDirection getPagingDirection() {
            throw new UnsupportedOperationException();
        }
    }
}

