/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.ConversationOpenParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationOpenParams
implements ConversationOpenParamsIF {
    @Nullable
    private final String channelId;
    private final List<String> users;
    private final boolean returnIm;

    private ConversationOpenParams(Builder builder) {
        this.channelId = builder.channelId;
        this.users = ConversationOpenParams.createUnmodifiableList(true, builder.users);
        this.returnIm = builder.returnImIsSet() ? builder.returnIm : ConversationOpenParamsIF.super.getReturnIm();
    }

    private ConversationOpenParams(@Nullable String channelId, List<String> users, boolean returnIm) {
        this.channelId = channelId;
        this.users = users;
        this.returnIm = returnIm;
    }

    @Override
    @JsonProperty(value="channel")
    public Optional<String> getChannelId() {
        return Optional.ofNullable(this.channelId);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    @JsonProperty
    public boolean getReturnIm() {
        return this.returnIm;
    }

    public final ConversationOpenParams withChannelId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.channelId, newValue)) {
            return this;
        }
        return new ConversationOpenParams(newValue, this.users, this.returnIm);
    }

    public final ConversationOpenParams withChannelId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.channelId, value)) {
            return this;
        }
        return new ConversationOpenParams(value, this.users, this.returnIm);
    }

    public final ConversationOpenParams withUsers(String ... elements) {
        List<String> newValue = ConversationOpenParams.createUnmodifiableList(false, ConversationOpenParams.createSafeList(Arrays.asList(elements), true, false));
        return new ConversationOpenParams(this.channelId, newValue, this.returnIm);
    }

    public final ConversationOpenParams withUsers(Iterable<String> elements) {
        if (this.users == elements) {
            return this;
        }
        List<String> newValue = ConversationOpenParams.createUnmodifiableList(false, ConversationOpenParams.createSafeList(elements, true, false));
        return new ConversationOpenParams(this.channelId, newValue, this.returnIm);
    }

    public final ConversationOpenParams withReturnIm(boolean returnIm) {
        if (this.returnIm == returnIm) {
            return this;
        }
        return new ConversationOpenParams(this.channelId, this.users, returnIm);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationOpenParams && this.equalTo((ConversationOpenParams)another);
    }

    private boolean equalTo(ConversationOpenParams another) {
        return Objects.equals(this.channelId, another.channelId) && this.users.equals(another.users) && this.returnIm == another.returnIm;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.channelId);
        h = h * 17 + this.users.hashCode();
        h = h * 17 + Boolean.hashCode(this.returnIm);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationOpenParams{");
        if (this.channelId != null) {
            builder.append("channelId=").append(this.channelId);
        }
        if (builder.length() > 23) {
            builder.append(", ");
        }
        builder.append("users=").append(this.users);
        builder.append(", ");
        builder.append("returnIm=").append(this.returnIm);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ConversationOpenParams fromJson(Json json) {
        Builder builder = ConversationOpenParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.users != null) {
            builder.addAllUsers(json.users);
        }
        if (json.returnImIsSet) {
            builder.setReturnIm(json.returnIm);
        }
        return builder.build();
    }

    public static ConversationOpenParams copyOf(ConversationOpenParamsIF instance) {
        if (instance instanceof ConversationOpenParams) {
            return (ConversationOpenParams)instance;
        }
        return ConversationOpenParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_RETURN_IM = 1L;
        private long optBits;
        @Nullable
        private String channelId;
        private List<String> users = new ArrayList<String>();
        private boolean returnIm;

        private Builder() {
        }

        public final Builder from(ConversationOpenParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> channelIdOptional = instance.getChannelId();
            if (channelIdOptional.isPresent()) {
                this.setChannelId(channelIdOptional);
            }
            this.addAllUsers(instance.getUsers());
            this.setReturnIm(instance.getReturnIm());
            return this;
        }

        public final Builder setChannelId(@Nullable String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Builder setChannelId(Optional<String> channelId) {
            this.channelId = channelId.orElse(null);
            return this;
        }

        public final Builder addUsers(String element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(String ... elements) {
            for (String element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder setUsers(Iterable<String> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<String> elements) {
            for (String element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder setReturnIm(boolean returnIm) {
            this.returnIm = returnIm;
            this.optBits |= 1L;
            return this;
        }

        public ConversationOpenParams build() throws InvalidImmutableStateException {
            return new ConversationOpenParams(this);
        }

        private boolean returnImIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationOpenParamsIF {
        Optional<String> channelId = Optional.empty();
        List<String> users = Collections.emptyList();
        boolean returnIm;
        boolean returnImIsSet;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(Optional<String> channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        @JsonIgnore
        public void setUsers(List<String> users) {
            this.users = users;
        }

        @JsonProperty
        public void setReturnIm(boolean returnIm) {
            this.returnIm = returnIm;
            this.returnImIsSet = true;
        }

        @Override
        public Optional<String> getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getUsers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getReturnIm() {
            throw new UnsupportedOperationException();
        }
    }
}

