/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.BaseConversationsFilter;
import com.hubspot.slack.client.methods.params.conversations.ConversationsListParamsIF;
import com.hubspot.slack.client.models.conversations.ConversationType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationsListParams
implements ConversationsListParamsIF {
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer limit;
    @Nullable
    private final Boolean shouldExcludeArchived;
    private final String types;
    private final Set<ConversationType> conversationTypes;

    private ConversationsListParams(@Nullable String cursor, @Nullable Integer limit, @Nullable Boolean shouldExcludeArchived, Set<ConversationType> conversationTypes) {
        this.cursor = cursor;
        this.limit = limit;
        this.shouldExcludeArchived = shouldExcludeArchived;
        this.conversationTypes = conversationTypes;
        this.types = Objects.requireNonNull(ConversationsListParamsIF.super.getTypes(), "types");
    }

    @Override
    @JsonProperty
    public Optional<String> getCursor() {
        return Optional.ofNullable(this.cursor);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="exclude_archived")
    public Optional<Boolean> shouldExcludeArchived() {
        return Optional.ofNullable(this.shouldExcludeArchived);
    }

    @Override
    @JsonProperty
    public String getTypes() {
        return this.types;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Set<ConversationType> getConversationTypes() {
        return this.conversationTypes;
    }

    public final ConversationsListParams withCursor(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.cursor, newValue)) {
            return this;
        }
        return new ConversationsListParams(newValue, this.limit, this.shouldExcludeArchived, this.conversationTypes);
    }

    public final ConversationsListParams withCursor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.cursor, value)) {
            return this;
        }
        return new ConversationsListParams(value, this.limit, this.shouldExcludeArchived, this.conversationTypes);
    }

    public final ConversationsListParams withLimit(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ConversationsListParams(this.cursor, newValue, this.shouldExcludeArchived, this.conversationTypes);
    }

    public final ConversationsListParams withLimit(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ConversationsListParams(this.cursor, value, this.shouldExcludeArchived, this.conversationTypes);
    }

    public final ConversationsListParams withShouldExcludeArchived(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.shouldExcludeArchived, newValue)) {
            return this;
        }
        return new ConversationsListParams(this.cursor, this.limit, newValue, this.conversationTypes);
    }

    public final ConversationsListParams withShouldExcludeArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.shouldExcludeArchived, value)) {
            return this;
        }
        return new ConversationsListParams(this.cursor, this.limit, value, this.conversationTypes);
    }

    public final ConversationsListParams withConversationTypes(ConversationType ... elements) {
        Set<ConversationType> newValue = ConversationsListParams.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ConversationsListParams(this.cursor, this.limit, this.shouldExcludeArchived, newValue);
    }

    public final ConversationsListParams withConversationTypes(Iterable<ConversationType> elements) {
        if (this.conversationTypes == elements) {
            return this;
        }
        Set<ConversationType> newValue = ConversationsListParams.createUnmodifiableEnumSet(elements);
        return new ConversationsListParams(this.cursor, this.limit, this.shouldExcludeArchived, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsListParams && this.equalTo((ConversationsListParams)another);
    }

    private boolean equalTo(ConversationsListParams another) {
        return Objects.equals(this.cursor, another.cursor) && Objects.equals(this.limit, another.limit) && Objects.equals(this.shouldExcludeArchived, another.shouldExcludeArchived) && this.types.equals(another.types) && this.conversationTypes.equals(another.conversationTypes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.cursor);
        h = h * 17 + Objects.hashCode(this.limit);
        h = h * 17 + Objects.hashCode(this.shouldExcludeArchived);
        h = h * 17 + this.types.hashCode();
        h = h * 17 + this.conversationTypes.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsListParams{");
        if (this.cursor != null) {
            builder.append("cursor=").append(this.cursor);
        }
        if (this.limit != null) {
            if (builder.length() > 24) {
                builder.append(", ");
            }
            builder.append("limit=").append(this.limit);
        }
        if (this.shouldExcludeArchived != null) {
            if (builder.length() > 24) {
                builder.append(", ");
            }
            builder.append("shouldExcludeArchived=").append(this.shouldExcludeArchived);
        }
        if (builder.length() > 24) {
            builder.append(", ");
        }
        builder.append("types=").append(this.types);
        builder.append(", ");
        builder.append("conversationTypes=").append(this.conversationTypes);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ConversationsListParams fromJson(Json json) {
        Builder builder = ConversationsListParams.builder();
        if (json.cursor != null) {
            builder.setCursor(json.cursor);
        }
        if (json.limit != null) {
            builder.setLimit(json.limit);
        }
        if (json.shouldExcludeArchived != null) {
            builder.setShouldExcludeArchived(json.shouldExcludeArchived);
        }
        if (json.conversationTypes != null) {
            builder.addAllConversationTypes(json.conversationTypes);
        }
        return builder.build();
    }

    public static ConversationsListParams copyOf(ConversationsListParamsIF instance) {
        if (instance instanceof ConversationsListParams) {
            return (ConversationsListParams)instance;
        }
        return ConversationsListParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ConversationsListParams.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String cursor;
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean shouldExcludeArchived;
        private EnumSet<ConversationType> conversationTypes = EnumSet.noneOf(ConversationType.class);

        private Builder() {
        }

        public final Builder from(BaseConversationsFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConversationsListParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseConversationsFilter instance;
            if (object instanceof BaseConversationsFilter) {
                instance = (BaseConversationsFilter)object;
                Optional<Boolean> shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
                if (shouldExcludeArchivedOptional.isPresent()) {
                    this.setShouldExcludeArchived(shouldExcludeArchivedOptional);
                }
                this.addAllConversationTypes(instance.getConversationTypes());
            }
            if (object instanceof ConversationsListParamsIF) {
                Optional<Integer> limitOptional;
                instance = (ConversationsListParamsIF)object;
                Optional<String> cursorOptional = instance.getCursor();
                if (cursorOptional.isPresent()) {
                    this.setCursor(cursorOptional);
                }
                if ((limitOptional = instance.getLimit()).isPresent()) {
                    this.setLimit(limitOptional);
                }
            }
        }

        public final Builder setCursor(@Nullable String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final Builder setCursor(Optional<String> cursor) {
            this.cursor = cursor.orElse(null);
            return this;
        }

        public final Builder setLimit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Builder setLimit(Optional<Integer> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        public final Builder setShouldExcludeArchived(@Nullable Boolean shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
            return this;
        }

        public final Builder setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived.orElse(null);
            return this;
        }

        public final Builder addConversationTypes(ConversationType element) {
            this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
            return this;
        }

        public final Builder addConversationTypes(ConversationType ... elements) {
            for (ConversationType element : elements) {
                this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
            }
            return this;
        }

        public final Builder setConversationTypes(Iterable<ConversationType> elements) {
            this.conversationTypes.clear();
            return this.addAllConversationTypes(elements);
        }

        public final Builder addAllConversationTypes(Iterable<ConversationType> elements) {
            for (ConversationType element : elements) {
                this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
            }
            return this;
        }

        public ConversationsListParams build() throws InvalidImmutableStateException {
            return new ConversationsListParams(this.cursor, this.limit, this.shouldExcludeArchived, ConversationsListParams.createUnmodifiableEnumSet(this.conversationTypes));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationsListParamsIF {
        Optional<String> cursor = Optional.empty();
        Optional<Integer> limit = Optional.empty();
        Optional<Boolean> shouldExcludeArchived = Optional.empty();
        Set<ConversationType> conversationTypes = Collections.emptySet();

        Json() {
        }

        @JsonProperty
        public void setCursor(Optional<String> cursor) {
            this.cursor = cursor;
        }

        @JsonProperty
        public void setLimit(Optional<Integer> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="exclude_archived")
        public void setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
        }

        @JsonProperty
        @JsonIgnore
        public void setConversationTypes(Set<ConversationType> conversationTypes) {
            this.conversationTypes = conversationTypes;
        }

        @Override
        public Optional<String> getCursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getLimit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> shouldExcludeArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ConversationType> getConversationTypes() {
            throw new UnsupportedOperationException();
        }
    }
}

