/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.ConversationsRepliesParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationsRepliesParams
implements ConversationsRepliesParamsIF {
    private final String channel;
    private final String ts;

    private ConversationsRepliesParams(String channel, String ts) {
        this.channel = channel;
        this.ts = ts;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    public final ConversationsRepliesParams withChannel(String channel) {
        if (this.channel.equals(channel)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channel, "channel");
        return new ConversationsRepliesParams(newValue, this.ts);
    }

    public final ConversationsRepliesParams withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new ConversationsRepliesParams(this.channel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsRepliesParams && this.equalTo((ConversationsRepliesParams)another);
    }

    private boolean equalTo(ConversationsRepliesParams another) {
        return this.channel.equals(another.channel) && this.ts.equals(another.ts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channel.hashCode();
        h = h * 17 + this.ts.hashCode();
        return h;
    }

    public String toString() {
        return "ConversationsRepliesParams{channel=" + this.channel + ", ts=" + this.ts + "}";
    }

    @Deprecated
    @JsonCreator
    static ConversationsRepliesParams fromJson(Json json) {
        Builder builder = ConversationsRepliesParams.builder();
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        return builder.build();
    }

    public static ConversationsRepliesParams copyOf(ConversationsRepliesParamsIF instance) {
        if (instance instanceof ConversationsRepliesParams) {
            return (ConversationsRepliesParams)instance;
        }
        return ConversationsRepliesParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private String channel;
        @Nullable
        private String ts;

        private Builder() {
        }

        public final Builder from(ConversationsRepliesParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setChannel(instance.getChannel());
            this.setTs(instance.getTs());
            return this;
        }

        public final Builder setChannel(String channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ConversationsRepliesParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationsRepliesParams(this.channel, this.ts);
        }

        private boolean channelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build ConversationsRepliesParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationsRepliesParamsIF {
        @Nullable
        String channel;
        @Nullable
        String ts;

        Json() {
        }

        @JsonProperty
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @Override
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }
    }
}

