/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.reactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.reactions.ReactionsAddParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ReactionsAddParams
implements ReactionsAddParamsIF {
    private final String name;
    @Nullable
    private final String channel;
    @Nullable
    private final String timestamp;
    @Nullable
    private final String file;
    @Nullable
    private final String fileComment;

    private ReactionsAddParams(String name, @Nullable String channel, @Nullable String timestamp, @Nullable String file, @Nullable String fileComment) {
        this.name = name;
        this.channel = channel;
        this.timestamp = timestamp;
        this.file = file;
        this.fileComment = fileComment;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> getChannel() {
        return Optional.ofNullable(this.channel);
    }

    @Override
    @JsonProperty
    public Optional<String> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    @Override
    @JsonProperty
    @Deprecated
    public Optional<String> getFile() {
        return Optional.ofNullable(this.file);
    }

    @Override
    @JsonProperty
    @Deprecated
    public Optional<String> getFileComment() {
        return Optional.ofNullable(this.fileComment);
    }

    public final ReactionsAddParams withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return ReactionsAddParams.validate(new ReactionsAddParams(newValue, this.channel, this.timestamp, this.file, this.fileComment));
    }

    public final ReactionsAddParams withChannel(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.channel, newValue)) {
            return this;
        }
        return ReactionsAddParams.validate(new ReactionsAddParams(this.name, newValue, this.timestamp, this.file, this.fileComment));
    }

    public final ReactionsAddParams withChannel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.channel, value)) {
            return this;
        }
        return ReactionsAddParams.validate(new ReactionsAddParams(this.name, value, this.timestamp, this.file, this.fileComment));
    }

    public final ReactionsAddParams withTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.timestamp, newValue)) {
            return this;
        }
        return ReactionsAddParams.validate(new ReactionsAddParams(this.name, this.channel, newValue, this.file, this.fileComment));
    }

    public final ReactionsAddParams withTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.timestamp, value)) {
            return this;
        }
        return ReactionsAddParams.validate(new ReactionsAddParams(this.name, this.channel, value, this.file, this.fileComment));
    }

    @Deprecated
    public final ReactionsAddParams withFile(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.file, newValue)) {
            return this;
        }
        return ReactionsAddParams.validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, newValue, this.fileComment));
    }

    @Deprecated
    public final ReactionsAddParams withFile(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.file, value)) {
            return this;
        }
        return ReactionsAddParams.validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, value, this.fileComment));
    }

    @Deprecated
    public final ReactionsAddParams withFileComment(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.fileComment, newValue)) {
            return this;
        }
        return ReactionsAddParams.validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, this.file, newValue));
    }

    @Deprecated
    public final ReactionsAddParams withFileComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.fileComment, value)) {
            return this;
        }
        return ReactionsAddParams.validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, this.file, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReactionsAddParams && this.equalTo((ReactionsAddParams)another);
    }

    private boolean equalTo(ReactionsAddParams another) {
        return this.name.equals(another.name) && Objects.equals(this.channel, another.channel) && Objects.equals(this.timestamp, another.timestamp) && Objects.equals(this.file, another.file) && Objects.equals(this.fileComment, another.fileComment);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.channel);
        h = h * 17 + Objects.hashCode(this.timestamp);
        h = h * 17 + Objects.hashCode(this.file);
        h = h * 17 + Objects.hashCode(this.fileComment);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ReactionsAddParams{");
        builder.append("name=").append(this.name);
        if (this.channel != null) {
            builder.append(", ");
            builder.append("channel=").append(this.channel);
        }
        if (this.timestamp != null) {
            builder.append(", ");
            builder.append("timestamp=").append(this.timestamp);
        }
        if (this.file != null) {
            builder.append(", ");
            builder.append("file=").append(this.file);
        }
        if (this.fileComment != null) {
            builder.append(", ");
            builder.append("fileComment=").append(this.fileComment);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ReactionsAddParams fromJson(Json json) {
        Builder builder = ReactionsAddParams.builder();
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.timestamp != null) {
            builder.setTimestamp(json.timestamp);
        }
        if (json.file != null) {
            builder.setFile(json.file);
        }
        if (json.fileComment != null) {
            builder.setFileComment(json.fileComment);
        }
        return builder.build();
    }

    private static ReactionsAddParams validate(ReactionsAddParams instance) {
        instance.reactionRecipientExists();
        return instance;
    }

    public static ReactionsAddParams copyOf(ReactionsAddParamsIF instance) {
        if (instance instanceof ReactionsAddParams) {
            return (ReactionsAddParams)instance;
        }
        return ReactionsAddParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String channel;
        @Nullable
        private String timestamp;
        @Nullable
        private String file;
        @Nullable
        private String fileComment;

        private Builder() {
        }

        public final Builder from(ReactionsAddParamsIF instance) {
            Optional<String> fileCommentOptional;
            Optional<String> fileOptional;
            Optional<String> timestampOptional;
            Objects.requireNonNull(instance, "instance");
            this.setName(instance.getName());
            Optional<String> channelOptional = instance.getChannel();
            if (channelOptional.isPresent()) {
                this.setChannel(channelOptional);
            }
            if ((timestampOptional = instance.getTimestamp()).isPresent()) {
                this.setTimestamp(timestampOptional);
            }
            if ((fileOptional = instance.getFile()).isPresent()) {
                this.setFile(fileOptional);
            }
            if ((fileCommentOptional = instance.getFileComment()).isPresent()) {
                this.setFileComment(fileCommentOptional);
            }
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannel(@Nullable String channel) {
            this.channel = channel;
            return this;
        }

        public final Builder setChannel(Optional<String> channel) {
            this.channel = channel.orElse(null);
            return this;
        }

        public final Builder setTimestamp(@Nullable String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Builder setTimestamp(Optional<String> timestamp) {
            this.timestamp = timestamp.orElse(null);
            return this;
        }

        @Deprecated
        public final Builder setFile(@Nullable String file) {
            this.file = file;
            return this;
        }

        @Deprecated
        public final Builder setFile(Optional<String> file) {
            this.file = file.orElse(null);
            return this;
        }

        @Deprecated
        public final Builder setFileComment(@Nullable String fileComment) {
            this.fileComment = fileComment;
            return this;
        }

        @Deprecated
        public final Builder setFileComment(Optional<String> fileComment) {
            this.fileComment = fileComment.orElse(null);
            return this;
        }

        public ReactionsAddParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return ReactionsAddParams.validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, this.file, this.fileComment));
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build ReactionsAddParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ReactionsAddParamsIF {
        @Nullable
        String name;
        Optional<String> channel = Optional.empty();
        Optional<String> timestamp = Optional.empty();
        Optional<String> file = Optional.empty();
        Optional<String> fileComment = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setChannel(Optional<String> channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setTimestamp(Optional<String> timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty
        public void setFile(Optional<String> file) {
            this.file = file;
        }

        @JsonProperty
        public void setFileComment(Optional<String> fileComment) {
            this.fileComment = fileComment;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getFileComment() {
            throw new UnsupportedOperationException();
        }
    }
}

