/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.ResultSort;
import com.hubspot.slack.client.methods.ResultSortOrder;
import com.hubspot.slack.client.methods.params.search.SearchMessagesParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SearchMessagesParams
implements SearchMessagesParamsIF {
    private final String query;
    private final boolean shouldHighlight;
    private final int count;
    private final int page;
    private final ResultSort sort;
    private final ResultSortOrder sortOrder;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SearchMessagesParams(Builder builder) {
        this.query = builder.query;
        if (builder.shouldHighlightIsSet()) {
            this.initShim.setShouldHighlight(builder.shouldHighlight);
        }
        if (builder.countIsSet()) {
            this.initShim.setCount(builder.count);
        }
        if (builder.pageIsSet()) {
            this.initShim.setPage(builder.page);
        }
        if (builder.sort != null) {
            this.initShim.setSort(builder.sort);
        }
        if (builder.sortOrder != null) {
            this.initShim.setSortOrder(builder.sortOrder);
        }
        this.shouldHighlight = this.initShim.shouldHighlight();
        this.count = this.initShim.getCount();
        this.page = this.initShim.getPage();
        this.sort = this.initShim.getSort();
        this.sortOrder = this.initShim.getSortOrder();
        this.initShim = null;
    }

    private SearchMessagesParams(String query, boolean shouldHighlight, int count, int page, ResultSort sort, ResultSortOrder sortOrder) {
        this.query = query;
        this.shouldHighlight = shouldHighlight;
        this.count = count;
        this.page = page;
        this.sort = sort;
        this.sortOrder = sortOrder;
        this.initShim = null;
    }

    private boolean shouldHighlightInitialize() {
        return SearchMessagesParamsIF.super.shouldHighlight();
    }

    private int getCountInitialize() {
        return SearchMessagesParamsIF.super.getCount();
    }

    private int getPageInitialize() {
        return SearchMessagesParamsIF.super.getPage();
    }

    private ResultSort getSortInitialize() {
        return SearchMessagesParamsIF.super.getSort();
    }

    private ResultSortOrder getSortOrderInitialize() {
        return SearchMessagesParamsIF.super.getSortOrder();
    }

    @Override
    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @Override
    @JsonProperty
    public boolean shouldHighlight() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shouldHighlight() : this.shouldHighlight;
    }

    @Override
    @JsonProperty
    public int getCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCount() : this.count;
    }

    @Override
    @JsonProperty
    public int getPage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPage() : this.page;
    }

    @Override
    @JsonProperty
    public ResultSort getSort() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSort() : this.sort;
    }

    @Override
    @JsonProperty(value="sort_dir")
    public ResultSortOrder getSortOrder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSortOrder() : this.sortOrder;
    }

    public final SearchMessagesParams withQuery(String query) {
        if (this.query.equals(query)) {
            return this;
        }
        String newValue = Objects.requireNonNull(query, "query");
        return new SearchMessagesParams(newValue, this.shouldHighlight, this.count, this.page, this.sort, this.sortOrder);
    }

    public final SearchMessagesParams withShouldHighlight(boolean shouldHighlight) {
        if (this.shouldHighlight == shouldHighlight) {
            return this;
        }
        return new SearchMessagesParams(this.query, shouldHighlight, this.count, this.page, this.sort, this.sortOrder);
    }

    public final SearchMessagesParams withCount(int count) {
        if (this.count == count) {
            return this;
        }
        return new SearchMessagesParams(this.query, this.shouldHighlight, count, this.page, this.sort, this.sortOrder);
    }

    public final SearchMessagesParams withPage(int page) {
        if (this.page == page) {
            return this;
        }
        return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, page, this.sort, this.sortOrder);
    }

    public final SearchMessagesParams withSort(ResultSort sort) {
        if (this.sort == sort) {
            return this;
        }
        ResultSort newValue = Objects.requireNonNull(sort, "sort");
        return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, this.page, newValue, this.sortOrder);
    }

    public final SearchMessagesParams withSortOrder(ResultSortOrder sortOrder) {
        if (this.sortOrder == sortOrder) {
            return this;
        }
        ResultSortOrder newValue = Objects.requireNonNull(sortOrder, "sortOrder");
        return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, this.page, this.sort, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SearchMessagesParams && this.equalTo((SearchMessagesParams)another);
    }

    private boolean equalTo(SearchMessagesParams another) {
        return this.query.equals(another.query) && this.shouldHighlight == another.shouldHighlight && this.count == another.count && this.page == another.page && this.sort.equals((Object)another.sort) && this.sortOrder.equals((Object)another.sortOrder);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.query.hashCode();
        h = h * 17 + Boolean.hashCode(this.shouldHighlight);
        h = h * 17 + this.count;
        h = h * 17 + this.page;
        h = h * 17 + this.sort.hashCode();
        h = h * 17 + this.sortOrder.hashCode();
        return h;
    }

    public String toString() {
        return "SearchMessagesParams{query=" + this.query + ", shouldHighlight=" + this.shouldHighlight + ", count=" + this.count + ", page=" + this.page + ", sort=" + (Object)((Object)this.sort) + ", sortOrder=" + (Object)((Object)this.sortOrder) + "}";
    }

    @Deprecated
    @JsonCreator
    static SearchMessagesParams fromJson(Json json) {
        Builder builder = SearchMessagesParams.builder();
        if (json.query != null) {
            builder.setQuery(json.query);
        }
        if (json.shouldHighlightIsSet) {
            builder.setShouldHighlight(json.shouldHighlight);
        }
        if (json.countIsSet) {
            builder.setCount(json.count);
        }
        if (json.pageIsSet) {
            builder.setPage(json.page);
        }
        if (json.sort != null) {
            builder.setSort(json.sort);
        }
        if (json.sortOrder != null) {
            builder.setSortOrder(json.sortOrder);
        }
        return builder.build();
    }

    public static SearchMessagesParams copyOf(SearchMessagesParamsIF instance) {
        if (instance instanceof SearchMessagesParams) {
            return (SearchMessagesParams)instance;
        }
        return SearchMessagesParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUERY = 1L;
        private static final long OPT_BIT_SHOULD_HIGHLIGHT = 1L;
        private static final long OPT_BIT_COUNT = 2L;
        private static final long OPT_BIT_PAGE = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String query;
        private boolean shouldHighlight;
        private int count;
        private int page;
        @Nullable
        private ResultSort sort;
        @Nullable
        private ResultSortOrder sortOrder;

        private Builder() {
        }

        public final Builder from(SearchMessagesParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setQuery(instance.getQuery());
            this.setShouldHighlight(instance.shouldHighlight());
            this.setCount(instance.getCount());
            this.setPage(instance.getPage());
            this.setSort(instance.getSort());
            this.setSortOrder(instance.getSortOrder());
            return this;
        }

        public final Builder setQuery(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setShouldHighlight(boolean shouldHighlight) {
            this.shouldHighlight = shouldHighlight;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setCount(int count) {
            this.count = count;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setPage(int page) {
            this.page = page;
            this.optBits |= 4L;
            return this;
        }

        public final Builder setSort(ResultSort sort) {
            this.sort = Objects.requireNonNull(sort, "sort");
            return this;
        }

        public final Builder setSortOrder(ResultSortOrder sortOrder) {
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder");
            return this;
        }

        public SearchMessagesParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SearchMessagesParams(this);
        }

        private boolean shouldHighlightIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean countIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean queryIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.queryIsSet()) {
                attributes.add("query");
            }
            return "Cannot build SearchMessagesParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SearchMessagesParamsIF {
        @Nullable
        String query;
        boolean shouldHighlight;
        boolean shouldHighlightIsSet;
        int count;
        boolean countIsSet;
        int page;
        boolean pageIsSet;
        @Nullable
        ResultSort sort;
        @Nullable
        ResultSortOrder sortOrder;

        Json() {
        }

        @JsonProperty
        public void setQuery(String query) {
            this.query = query;
        }

        @JsonProperty
        public void setShouldHighlight(boolean shouldHighlight) {
            this.shouldHighlight = shouldHighlight;
            this.shouldHighlightIsSet = true;
        }

        @JsonProperty
        public void setCount(int count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty
        public void setPage(int page) {
            this.page = page;
            this.pageIsSet = true;
        }

        @JsonProperty
        public void setSort(ResultSort sort) {
            this.sort = sort;
        }

        @JsonProperty(value="sort_dir")
        public void setSortOrder(ResultSortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public String getQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldHighlight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSort getSort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSortOrder getSortOrder() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private boolean shouldHighlight;
        private int shouldHighlightStage;
        private int count;
        private int countStage;
        private int page;
        private int pageStage;
        private ResultSort sort;
        private int sortStage;
        private ResultSortOrder sortOrder;
        private int sortOrderStage;

        private InitShim() {
        }

        boolean shouldHighlight() {
            if (this.shouldHighlightStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.shouldHighlightStage == 0) {
                this.shouldHighlightStage = -1;
                this.shouldHighlight = SearchMessagesParams.this.shouldHighlightInitialize();
                this.shouldHighlightStage = 1;
            }
            return this.shouldHighlight;
        }

        void setShouldHighlight(boolean shouldHighlight) {
            this.shouldHighlight = shouldHighlight;
            this.shouldHighlightStage = 1;
        }

        int getCount() {
            if (this.countStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.countStage == 0) {
                this.countStage = -1;
                this.count = SearchMessagesParams.this.getCountInitialize();
                this.countStage = 1;
            }
            return this.count;
        }

        void setCount(int count) {
            this.count = count;
            this.countStage = 1;
        }

        int getPage() {
            if (this.pageStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.pageStage == 0) {
                this.pageStage = -1;
                this.page = SearchMessagesParams.this.getPageInitialize();
                this.pageStage = 1;
            }
            return this.page;
        }

        void setPage(int page) {
            this.page = page;
            this.pageStage = 1;
        }

        ResultSort getSort() {
            if (this.sortStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.sortStage == 0) {
                this.sortStage = -1;
                this.sort = Objects.requireNonNull(SearchMessagesParams.this.getSortInitialize(), "sort");
                this.sortStage = 1;
            }
            return this.sort;
        }

        void setSort(ResultSort sort) {
            this.sort = sort;
            this.sortStage = 1;
        }

        ResultSortOrder getSortOrder() {
            if (this.sortOrderStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.sortOrderStage == 0) {
                this.sortOrderStage = -1;
                this.sortOrder = Objects.requireNonNull(SearchMessagesParams.this.getSortOrderInitialize(), "sortOrder");
                this.sortOrderStage = 1;
            }
            return this.sortOrder;
        }

        void setSortOrder(ResultSortOrder sortOrder) {
            this.sortOrder = sortOrder;
            this.sortOrderStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.shouldHighlightStage == -1) {
                attributes.add("shouldHighlight");
            }
            if (this.countStage == -1) {
                attributes.add("count");
            }
            if (this.pageStage == -1) {
                attributes.add("page");
            }
            if (this.sortStage == -1) {
                attributes.add("sort");
            }
            if (this.sortOrderStage == -1) {
                attributes.add("sortOrder");
            }
            return "Cannot build SearchMessagesParams, attribute initializers form cycle" + attributes;
        }
    }
}

