/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.views.PublishViewParamsIF;
import com.hubspot.slack.client.models.views.HomeTabViewPayload;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class PublishViewParams
implements PublishViewParamsIF {
    private final String userId;
    private final HomeTabViewPayload view;
    @Nullable
    private final String hash;

    private PublishViewParams(String userId, HomeTabViewPayload view) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.view = Objects.requireNonNull(view, "view");
        this.hash = null;
    }

    private PublishViewParams(String userId, HomeTabViewPayload view, @Nullable String hash) {
        this.userId = userId;
        this.view = view;
        this.hash = hash;
    }

    @Override
    @JsonProperty
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public HomeTabViewPayload getView() {
        return this.view;
    }

    @Override
    @JsonProperty
    public Optional<String> getHash() {
        return Optional.ofNullable(this.hash);
    }

    public final PublishViewParams withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new PublishViewParams(newValue, this.view, this.hash);
    }

    public final PublishViewParams withView(HomeTabViewPayload view) {
        if (this.view == view) {
            return this;
        }
        HomeTabViewPayload newValue = Objects.requireNonNull(view, "view");
        return new PublishViewParams(this.userId, newValue, this.hash);
    }

    public final PublishViewParams withHash(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.hash, newValue)) {
            return this;
        }
        return new PublishViewParams(this.userId, this.view, newValue);
    }

    public final PublishViewParams withHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return new PublishViewParams(this.userId, this.view, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PublishViewParams && this.equalTo((PublishViewParams)another);
    }

    private boolean equalTo(PublishViewParams another) {
        return this.userId.equals(another.userId) && this.view.equals(another.view) && Objects.equals(this.hash, another.hash);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + this.view.hashCode();
        h = h * 17 + Objects.hashCode(this.hash);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PublishViewParams{");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("view=").append(this.view);
        if (this.hash != null) {
            builder.append(", ");
            builder.append("hash=").append(this.hash);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static PublishViewParams fromJson(Json json) {
        Builder builder = PublishViewParams.builder();
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.hash != null) {
            builder.setHash(json.hash);
        }
        return builder.build();
    }

    public static PublishViewParams of(String userId, HomeTabViewPayload view) {
        return new PublishViewParams(userId, view);
    }

    public static PublishViewParams copyOf(PublishViewParamsIF instance) {
        if (instance instanceof PublishViewParams) {
            return (PublishViewParams)instance;
        }
        return PublishViewParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_VIEW = 2L;
        private long initBits = 3L;
        @Nullable
        private String userId;
        @Nullable
        private HomeTabViewPayload view;
        @Nullable
        private String hash;

        private Builder() {
        }

        public final Builder from(PublishViewParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setUserId(instance.getUserId());
            this.setView(instance.getView());
            Optional<String> hashOptional = instance.getHash();
            if (hashOptional.isPresent()) {
                this.setHash(hashOptional);
            }
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setView(HomeTabViewPayload view) {
            this.view = Objects.requireNonNull(view, "view");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setHash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        public final Builder setHash(Optional<String> hash) {
            this.hash = hash.orElse(null);
            return this;
        }

        public PublishViewParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new PublishViewParams(this.userId, this.view, this.hash);
        }

        private boolean userIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean viewIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.viewIsSet()) {
                attributes.add("view");
            }
            return "Cannot build PublishViewParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PublishViewParamsIF {
        @Nullable
        String userId;
        @Nullable
        HomeTabViewPayload view;
        Optional<String> hash = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setView(HomeTabViewPayload view) {
            this.view = view;
        }

        @JsonProperty
        public void setHash(Optional<String> hash) {
            this.hash = hash;
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HomeTabViewPayload getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHash() {
            throw new UnsupportedOperationException();
        }
    }
}

