/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.views;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.views.ModalViewPayload;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@HubSpotStyle
public interface UpdateViewParamsIF {
    @Value.Parameter
    public ModalViewPayload getView();

    public Optional<String> getExternalId();

    public Optional<String> getHash();

    public Optional<String> getViewId();

    @Value.Check
    default public void check() {
        boolean externalIdSet = !Strings.isNullOrEmpty((String)this.getExternalId().orElse(null));
        boolean viewIdSet = !Strings.isNullOrEmpty((String)this.getViewId().orElse(null));
        Preconditions.checkState((!(!externalIdSet && !viewIdSet || externalIdSet && viewIdSet) ? 1 : 0) != 0, (Object)"Must include either view_id or external_id");
    }
}

