/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.FileIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class File
implements FileIF {
    private final String type;
    private final String externalId;
    private final String source;
    @Nullable
    private final String blockId;

    private File(String externalId, String source) {
        this.externalId = Objects.requireNonNull(externalId, "externalId");
        this.source = Objects.requireNonNull(source, "source");
        this.blockId = null;
        this.type = Objects.requireNonNull(FileIF.super.getType(), "type");
    }

    private File(String externalId, String source, @Nullable String blockId) {
        this.externalId = externalId;
        this.source = source;
        this.blockId = blockId;
        this.type = Objects.requireNonNull(FileIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    @JsonProperty
    public String getSource() {
        return this.source;
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    public final File withExternalId(String externalId) {
        if (this.externalId.equals(externalId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(externalId, "externalId");
        return new File(newValue, this.source, this.blockId);
    }

    public final File withSource(String source) {
        if (this.source.equals(source)) {
            return this;
        }
        String newValue = Objects.requireNonNull(source, "source");
        return new File(this.externalId, newValue, this.blockId);
    }

    public final File withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new File(this.externalId, this.source, newValue);
    }

    public final File withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new File(this.externalId, this.source, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof File && this.equalTo((File)another);
    }

    private boolean equalTo(File another) {
        return this.type.equals(another.type) && this.externalId.equals(another.externalId) && this.source.equals(another.source) && Objects.equals(this.blockId, another.blockId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.externalId.hashCode();
        h = h * 17 + this.source.hashCode();
        h = h * 17 + Objects.hashCode(this.blockId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("File{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("externalId=").append(this.externalId);
        builder.append(", ");
        builder.append("source=").append(this.source);
        if (this.blockId != null) {
            builder.append(", ");
            builder.append("blockId=").append(this.blockId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static File fromJson(Json json) {
        Builder builder = File.builder();
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        if (json.source != null) {
            builder.setSource(json.source);
        }
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static File of(String externalId, String source) {
        return new File(externalId, source);
    }

    public static File copyOf(FileIF instance) {
        if (instance instanceof File) {
            return (File)instance;
        }
        return File.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXTERNAL_ID = 1L;
        private static final long INIT_BIT_SOURCE = 2L;
        private long initBits = 3L;
        @Nullable
        private String externalId;
        @Nullable
        private String source;
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FileIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Block instance;
            Optional<String> blockIdOptional;
            if (object instanceof Block && (blockIdOptional = (instance = (Block)object).getBlockId()).isPresent()) {
                this.setBlockId(blockIdOptional);
            }
            if (object instanceof FileIF) {
                instance = (FileIF)object;
                this.setExternalId(instance.getExternalId());
                this.setSource(instance.getSource());
            }
        }

        public final Builder setExternalId(String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSource(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public File build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new File(this.externalId, this.source, this.blockId);
        }

        private boolean externalIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean sourceIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.externalIdIsSet()) {
                attributes.add("externalId");
            }
            if (!this.sourceIsSet()) {
                attributes.add("source");
            }
            return "Cannot build File, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FileIF {
        @Nullable
        String externalId;
        @Nullable
        String source;
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setSource(String source) {
            this.source = source;
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }
    }
}

