/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.actions.SlackDataSource;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOption;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@HubSpotStyle
public abstract class AbstractSlackFormSelectElement
extends SlackDialogFormElement {
    @Override
    @Value.Default
    public SlackFormElementTypes getType() {
        return SlackFormElementTypes.SELECT;
    }

    @Value.Default
    public SlackDataSource getDataSource() {
        return SlackDataSource.STATIC;
    }

    public abstract List<SlackFormOption> getOptions();

    public abstract List<SlackFormOptionGroup> getOptionGroups();

    public abstract Optional<String> getValue();

    public abstract List<SlackFormOption> getSelectedOptions();

    public abstract Optional<Integer> getMinQueryLength();

    @Value.Check
    public void validate() {
        boolean valueIsSomeOptionValue;
        super.validateBaseElementProperties();
        ArrayList<String> errors = new ArrayList<String>();
        int numOptions = this.getOptions().size();
        int numOptionGroups = this.getOptionGroups().size();
        if (numOptions > 100) {
            errors.add("Cannot have more than 100 options");
        }
        if (numOptionGroups > 100) {
            errors.add("Cannot have more than 100 option groups");
        }
        if (this.getDataSource().equals((Object)SlackDataSource.STATIC) && numOptions == 0 && numOptionGroups == 0) {
            errors.add("Either options or option groups are required for static data source types");
        }
        if (this.getValue().isPresent() && this.getDataSource().equals((Object)SlackDataSource.EXTERNAL)) {
            errors.add("Cannot use value for external data source, must use selected options");
        }
        if (this.getValue().isPresent() && !(valueIsSomeOptionValue = this.getOptions().stream().anyMatch(option -> option.getValue().equalsIgnoreCase(this.getValue().get())))) {
            errors.add("Value must exactly match the value field for one provided option");
        }
        if (!this.getSelectedOptions().isEmpty()) {
            boolean selectedOptionIsInOptions;
            if (this.getSelectedOptions().size() != 1) {
                errors.add("Selected options must be a single element array");
            }
            if (!this.getOptionGroups().isEmpty()) {
                boolean selectedOptionIsInOptionsGroup = this.getOptionGroups().stream().map(SlackFormOptionGroup::getOptions).collect(Collectors.toList()).stream().flatMap(Collection::stream).anyMatch(option -> option.equals(this.getSelectedOptions().get(0)));
                if (!selectedOptionIsInOptionsGroup) {
                    errors.add("Selected option must exactly match an option in the provided options groups");
                }
            } else if (!this.getOptions().isEmpty() && !(selectedOptionIsInOptions = this.getOptions().stream().anyMatch(option -> option.equals(this.getSelectedOptions().get(0))))) {
                errors.add("Selected option must exactly match an option in the provided options");
            }
        }
        if (!errors.isEmpty()) {
            throw new IllegalStateException(((Object)errors).toString());
        }
    }
}

