/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOption;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionGroupIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackFormOptionGroup
implements SlackFormOptionGroupIF {
    private final String label;
    private final List<SlackFormOption> options;

    private SlackFormOptionGroup(String label, List<SlackFormOption> options) {
        this.label = label;
        this.options = options;
    }

    @Override
    @JsonProperty
    public String getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public List<SlackFormOption> getOptions() {
        return this.options;
    }

    public final SlackFormOptionGroup withLabel(String label) {
        if (this.label.equals(label)) {
            return this;
        }
        String newValue = Objects.requireNonNull(label, "label");
        return SlackFormOptionGroup.validate(new SlackFormOptionGroup(newValue, this.options));
    }

    public final SlackFormOptionGroup withOptions(SlackFormOption ... elements) {
        List<SlackFormOption> newValue = SlackFormOptionGroup.createUnmodifiableList(false, SlackFormOptionGroup.createSafeList(Arrays.asList(elements), true, false));
        return SlackFormOptionGroup.validate(new SlackFormOptionGroup(this.label, newValue));
    }

    public final SlackFormOptionGroup withOptions(Iterable<? extends SlackFormOption> elements) {
        if (this.options == elements) {
            return this;
        }
        List<SlackFormOption> newValue = SlackFormOptionGroup.createUnmodifiableList(false, SlackFormOptionGroup.createSafeList(elements, true, false));
        return SlackFormOptionGroup.validate(new SlackFormOptionGroup(this.label, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackFormOptionGroup && this.equalTo((SlackFormOptionGroup)another);
    }

    private boolean equalTo(SlackFormOptionGroup another) {
        return this.label.equals(another.label) && this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.label.hashCode();
        h = h * 17 + this.options.hashCode();
        return h;
    }

    public String toString() {
        return "SlackFormOptionGroup{label=" + this.label + ", options=" + this.options + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackFormOptionGroup fromJson(Json json) {
        Builder builder = SlackFormOptionGroup.builder();
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        return builder.build();
    }

    private static SlackFormOptionGroup validate(SlackFormOptionGroup instance) {
        instance.validate();
        return instance;
    }

    public static SlackFormOptionGroup copyOf(SlackFormOptionGroupIF instance) {
        if (instance instanceof SlackFormOptionGroup) {
            return (SlackFormOptionGroup)instance;
        }
        return SlackFormOptionGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private long initBits = 1L;
        @Nullable
        private String label;
        private List<SlackFormOption> options = new ArrayList<SlackFormOption>();

        private Builder() {
        }

        public final Builder from(SlackFormOptionGroupIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setLabel(instance.getLabel());
            this.addAllOptions(instance.getOptions());
            return this;
        }

        public final Builder setLabel(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addOptions(SlackFormOption element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(SlackFormOption ... elements) {
            for (SlackFormOption element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends SlackFormOption> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends SlackFormOption> elements) {
            for (SlackFormOption slackFormOption : elements) {
                this.options.add(Objects.requireNonNull(slackFormOption, "options element"));
            }
            return this;
        }

        public SlackFormOptionGroup build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return SlackFormOptionGroup.validate(new SlackFormOptionGroup(this.label, SlackFormOptionGroup.createUnmodifiableList(true, this.options)));
        }

        private boolean labelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            return "Cannot build SlackFormOptionGroup, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackFormOptionGroupIF {
        @Nullable
        String label;
        List<SlackFormOption> options = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty
        public void setOptions(List<SlackFormOption> options) {
            this.options = options;
        }

        @Override
        public String getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFormOption> getOptions() {
            throw new UnsupportedOperationException();
        }
    }
}

