/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementSubtypes;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackDialogFormTextElement;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormTextElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackFormTextElement
extends AbstractSlackFormTextElement {
    private final SlackFormElementTypes type;
    @Nullable
    private final SlackFormElementSubtypes subtype;
    @Nullable
    private final String hint;
    private final int minLength;
    private final int maxLength;
    @Nullable
    private final String value;
    private final String name;
    private final String label;
    @Nullable
    private final String placeholder;
    @Nullable
    private final Boolean optional;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackFormTextElement(Builder builder) {
        this.subtype = builder.subtype;
        this.hint = builder.hint;
        this.value = builder.value;
        this.name = builder.name;
        this.label = builder.label;
        this.placeholder = builder.placeholder;
        this.optional = builder.optional;
        if (builder.type != null) {
            this.initShim.setType(builder.type);
        }
        if (builder.minLengthIsSet()) {
            this.initShim.setMinLength(builder.minLength);
        }
        if (builder.maxLengthIsSet()) {
            this.initShim.setMaxLength(builder.maxLength);
        }
        this.type = this.initShim.getType();
        this.minLength = this.initShim.getMinLength();
        this.maxLength = this.initShim.getMaxLength();
        this.initShim = null;
    }

    private SlackFormTextElement(SlackFormElementTypes type, @Nullable SlackFormElementSubtypes subtype, @Nullable String hint, int minLength, int maxLength, @Nullable String value, String name, String label, @Nullable String placeholder, @Nullable Boolean optional) {
        this.type = type;
        this.subtype = subtype;
        this.hint = hint;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.value = value;
        this.name = name;
        this.label = label;
        this.placeholder = placeholder;
        this.optional = optional;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public SlackFormElementTypes getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    @Override
    @JsonProperty
    public Optional<SlackFormElementSubtypes> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public Optional<String> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    @JsonProperty
    public int getMinLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinLength() : this.minLength;
    }

    @Override
    @JsonProperty
    public int getMaxLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxLength() : this.maxLength;
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public Optional<String> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty(value="optional")
    public Optional<Boolean> isOptional() {
        return Optional.ofNullable(this.optional);
    }

    public final SlackFormTextElement withType(SlackFormElementTypes type) {
        if (this.type == type) {
            return this;
        }
        SlackFormElementTypes newValue = Objects.requireNonNull(type, "type");
        return SlackFormTextElement.validate(new SlackFormTextElement(newValue, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withSubtype(@Nullable SlackFormElementSubtypes value) {
        SlackFormElementSubtypes newValue = value;
        if (Objects.equals((Object)this.subtype, (Object)newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, newValue, this.hint, this.minLength, this.maxLength, this.value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withSubtype(Optional<SlackFormElementSubtypes> optional) {
        SlackFormElementSubtypes value = optional.orElse(null);
        if (Objects.equals((Object)this.subtype, (Object)value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, value, this.hint, this.minLength, this.maxLength, this.value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withHint(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.hint, newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, newValue, this.minLength, this.maxLength, this.value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withHint(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hint, value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, value, this.minLength, this.maxLength, this.value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withMinLength(int minLength) {
        if (this.minLength == minLength) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, minLength, this.maxLength, this.value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withMaxLength(int maxLength) {
        if (this.maxLength == maxLength) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, maxLength, this.value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, this.maxLength, newValue, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, this.maxLength, value, this.name, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, this.maxLength, this.value, newValue, this.label, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withLabel(String label) {
        if (this.label.equals(label)) {
            return this;
        }
        String newValue = Objects.requireNonNull(label, "label");
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.name, newValue, this.placeholder, this.optional));
    }

    public final SlackFormTextElement withPlaceholder(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.placeholder, newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.name, this.label, newValue, this.optional));
    }

    public final SlackFormTextElement withPlaceholder(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.placeholder, value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.name, this.label, value, this.optional));
    }

    public final SlackFormTextElement withOptional(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.optional, newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.name, this.label, this.placeholder, newValue));
    }

    public final SlackFormTextElement withOptional(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.optional, value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.type, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.name, this.label, this.placeholder, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackFormTextElement && this.equalTo((SlackFormTextElement)another);
    }

    private boolean equalTo(SlackFormTextElement another) {
        return this.type.equals((Object)another.type) && Objects.equals((Object)this.subtype, (Object)another.subtype) && Objects.equals(this.hint, another.hint) && this.minLength == another.minLength && this.maxLength == another.maxLength && Objects.equals(this.value, another.value) && this.name.equals(another.name) && this.label.equals(another.label) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.optional, another.optional);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.subtype);
        h = h * 17 + Objects.hashCode(this.hint);
        h = h * 17 + this.minLength;
        h = h * 17 + this.maxLength;
        h = h * 17 + Objects.hashCode(this.value);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.label.hashCode();
        h = h * 17 + Objects.hashCode(this.placeholder);
        h = h * 17 + Objects.hashCode(this.optional);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackFormTextElement{");
        builder.append("type=").append((Object)this.type);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        if (this.hint != null) {
            builder.append(", ");
            builder.append("hint=").append(this.hint);
        }
        builder.append(", ");
        builder.append("minLength=").append(this.minLength);
        builder.append(", ");
        builder.append("maxLength=").append(this.maxLength);
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("label=").append(this.label);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.optional != null) {
            builder.append(", ");
            builder.append("optional=").append(this.optional);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackFormTextElement fromJson(Json json) {
        Builder builder = SlackFormTextElement.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.hint != null) {
            builder.setHint(json.hint);
        }
        if (json.minLengthIsSet) {
            builder.setMinLength(json.minLength);
        }
        if (json.maxLengthIsSet) {
            builder.setMaxLength(json.maxLength);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.optional != null) {
            builder.setOptional(json.optional);
        }
        return builder.build();
    }

    private static SlackFormTextElement validate(SlackFormTextElement instance) {
        instance.validate();
        return instance;
    }

    public static SlackFormTextElement copyOf(AbstractSlackFormTextElement instance) {
        if (instance instanceof SlackFormTextElement) {
            return (SlackFormTextElement)instance;
        }
        return SlackFormTextElement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_LABEL = 2L;
        private static final long OPT_BIT_MIN_LENGTH = 1L;
        private static final long OPT_BIT_MAX_LENGTH = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private SlackFormElementTypes type;
        @Nullable
        private SlackFormElementSubtypes subtype;
        @Nullable
        private String hint;
        private int minLength;
        private int maxLength;
        @Nullable
        private String value;
        @Nullable
        private String name;
        @Nullable
        private String label;
        @Nullable
        private String placeholder;
        @Nullable
        private Boolean optional;

        private Builder() {
        }

        public final Builder from(SlackDialogFormElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSlackFormTextElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSlackDialogFormTextElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackDialogFormElement instance;
            long bits = 0L;
            if (object instanceof SlackDialogFormElement) {
                instance = (SlackDialogFormElement)object;
                this.setName(instance.getName());
                Optional<Boolean> optionalOptional = instance.isOptional();
                if (optionalOptional.isPresent()) {
                    this.setOptional(optionalOptional);
                }
                this.setLabel(instance.getLabel());
                Optional<String> placeholderOptional = instance.getPlaceholder();
                if (placeholderOptional.isPresent()) {
                    this.setPlaceholder(placeholderOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractSlackFormTextElement) {
                instance = (AbstractSlackFormTextElement)object;
                if ((bits & 1L) == 0L) {
                    this.setType(((AbstractSlackFormTextElement)instance).getType());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractSlackDialogFormTextElement) {
                Optional<String> valueOptional;
                instance = (AbstractSlackDialogFormTextElement)object;
                Optional<SlackFormElementSubtypes> subtypeOptional = ((AbstractSlackDialogFormTextElement)instance).getSubtype();
                if (subtypeOptional.isPresent()) {
                    this.setSubtype(subtypeOptional);
                }
                if ((valueOptional = ((AbstractSlackDialogFormTextElement)instance).getValue()).isPresent()) {
                    this.setValue(valueOptional);
                }
                this.setMaxLength(((AbstractSlackDialogFormTextElement)instance).getMaxLength());
                Optional<String> hintOptional = ((AbstractSlackDialogFormTextElement)instance).getHint();
                if (hintOptional.isPresent()) {
                    this.setHint(hintOptional);
                }
                this.setMinLength(((AbstractSlackDialogFormTextElement)instance).getMinLength());
            }
        }

        public final Builder setType(SlackFormElementTypes type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public final Builder setSubtype(@Nullable SlackFormElementSubtypes subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<SlackFormElementSubtypes> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setHint(@Nullable String hint) {
            this.hint = hint;
            return this;
        }

        public final Builder setHint(Optional<String> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder setMinLength(int minLength) {
            this.minLength = minLength;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setLabel(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<String> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setOptional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final Builder setOptional(Optional<Boolean> optional) {
            this.optional = optional.orElse(null);
            return this;
        }

        public SlackFormTextElement build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return SlackFormTextElement.validate(new SlackFormTextElement(this));
        }

        private boolean minLengthIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean maxLengthIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean labelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            return "Cannot build SlackFormTextElement, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractSlackFormTextElement {
        @Nullable
        SlackFormElementTypes type;
        Optional<SlackFormElementSubtypes> subtype = Optional.empty();
        Optional<String> hint = Optional.empty();
        int minLength;
        boolean minLengthIsSet;
        int maxLength;
        boolean maxLengthIsSet;
        Optional<String> value = Optional.empty();
        @Nullable
        String name;
        @Nullable
        String label;
        Optional<String> placeholder = Optional.empty();
        Optional<Boolean> optional = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(SlackFormElementTypes type) {
            this.type = type;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackFormElementSubtypes> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setHint(Optional<String> hint) {
            this.hint = hint;
        }

        @JsonProperty
        public void setMinLength(int minLength) {
            this.minLength = minLength;
            this.minLengthIsSet = true;
        }

        @JsonProperty
        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            this.maxLengthIsSet = true;
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty
        public void setPlaceholder(Optional<String> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty(value="optional")
        public void setOptional(Optional<Boolean> optional) {
            this.optional = optional;
        }

        @Override
        public SlackFormElementTypes getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackFormElementSubtypes> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMinLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMaxLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isOptional() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private SlackFormElementTypes type;
        private int typeStage;
        private int minLength;
        private int minLengthStage;
        private int maxLength;
        private int maxLengthStage;

        private InitShim() {
        }

        SlackFormElementTypes getType() {
            if (this.typeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.typeStage == 0) {
                this.typeStage = -1;
                this.type = Objects.requireNonNull(SlackFormTextElement.super.getType(), "type");
                this.typeStage = 1;
            }
            return this.type;
        }

        void setType(SlackFormElementTypes type) {
            this.type = type;
            this.typeStage = 1;
        }

        int getMinLength() {
            if (this.minLengthStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.minLengthStage == 0) {
                this.minLengthStage = -1;
                this.minLength = SlackFormTextElement.super.getMinLength();
                this.minLengthStage = 1;
            }
            return this.minLength;
        }

        void setMinLength(int minLength) {
            this.minLength = minLength;
            this.minLengthStage = 1;
        }

        int getMaxLength() {
            if (this.maxLengthStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.maxLengthStage == 0) {
                this.maxLengthStage = -1;
                this.maxLength = SlackFormTextElement.super.getMaxLength();
                this.maxLengthStage = 1;
            }
            return this.maxLength;
        }

        void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            this.maxLengthStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.typeStage == -1) {
                attributes.add("type");
            }
            if (this.minLengthStage == -1) {
                attributes.add("minLength");
            }
            if (this.maxLengthStage == -1) {
                attributes.add("maxLength");
            }
            return "Cannot build SlackFormTextElement, attribute initializers form cycle" + attributes;
        }
    }
}

