/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.events.AbstractSlackEventBotMessage;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackEventBotMessage
extends AbstractSlackEventBotMessage {
    private final String channelId;
    @Nullable
    private final String text;
    private final List<Attachment> attachments;
    private final String botId;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final SlackEventType type;
    private final String ts;

    private SlackEventBotMessage(String channelId, @Nullable String text, List<Attachment> attachments, String botId, @Nullable SlackMessageSubtype subtype, SlackEventType type, String ts) {
        this.channelId = channelId;
        this.text = text;
        this.attachments = attachments;
        this.botId = botId;
        this.subtype = subtype;
        this.type = type;
        this.ts = ts;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public String getBotId() {
        return this.botId;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    public final SlackEventBotMessage withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlackEventBotMessage(newValue, this.text, this.attachments, this.botId, this.subtype, this.type, this.ts);
    }

    public final SlackEventBotMessage withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return new SlackEventBotMessage(this.channelId, newValue, this.attachments, this.botId, this.subtype, this.type, this.ts);
    }

    public final SlackEventBotMessage withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return new SlackEventBotMessage(this.channelId, value, this.attachments, this.botId, this.subtype, this.type, this.ts);
    }

    public final SlackEventBotMessage withAttachments(Attachment ... elements) {
        List<Attachment> newValue = SlackEventBotMessage.createUnmodifiableList(false, SlackEventBotMessage.createSafeList(Arrays.asList(elements), true, false));
        return new SlackEventBotMessage(this.channelId, this.text, newValue, this.botId, this.subtype, this.type, this.ts);
    }

    public final SlackEventBotMessage withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = SlackEventBotMessage.createUnmodifiableList(false, SlackEventBotMessage.createSafeList(elements, true, false));
        return new SlackEventBotMessage(this.channelId, this.text, newValue, this.botId, this.subtype, this.type, this.ts);
    }

    public final SlackEventBotMessage withBotId(String botId) {
        if (this.botId.equals(botId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(botId, "botId");
        return new SlackEventBotMessage(this.channelId, this.text, this.attachments, newValue, this.subtype, this.type, this.ts);
    }

    public final SlackEventBotMessage withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (Objects.equals((Object)this.subtype, (Object)newValue)) {
            return this;
        }
        return new SlackEventBotMessage(this.channelId, this.text, this.attachments, this.botId, newValue, this.type, this.ts);
    }

    public final SlackEventBotMessage withSubtype(Optional<SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (Objects.equals((Object)this.subtype, (Object)value)) {
            return this;
        }
        return new SlackEventBotMessage(this.channelId, this.text, this.attachments, this.botId, value, this.type, this.ts);
    }

    public final SlackEventBotMessage withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackEventBotMessage(this.channelId, this.text, this.attachments, this.botId, this.subtype, newValue, this.ts);
    }

    public final SlackEventBotMessage withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new SlackEventBotMessage(this.channelId, this.text, this.attachments, this.botId, this.subtype, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventBotMessage && this.equalTo((SlackEventBotMessage)another);
    }

    private boolean equalTo(SlackEventBotMessage another) {
        return this.channelId.equals(another.channelId) && Objects.equals(this.text, another.text) && this.attachments.equals(another.attachments) && this.botId.equals(another.botId) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.type.equals((Object)another.type) && this.ts.equals(another.ts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + Objects.hashCode(this.text);
        h = h * 17 + this.attachments.hashCode();
        h = h * 17 + this.botId.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.subtype);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.ts.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventBotMessage{");
        builder.append("channelId=").append(this.channelId);
        if (this.text != null) {
            builder.append(", ");
            builder.append("text=").append(this.text);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("botId=").append(this.botId);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackEventBotMessage fromJson(Json json) {
        Builder builder = SlackEventBotMessage.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.botId != null) {
            builder.setBotId(json.botId);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        return builder.build();
    }

    public static SlackEventBotMessage copyOf(AbstractSlackEventBotMessage instance) {
        if (instance instanceof SlackEventBotMessage) {
            return (SlackEventBotMessage)instance;
        }
        return SlackEventBotMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_BOT_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_TS = 8L;
        private long initBits = 15L;
        @Nullable
        private String channelId;
        @Nullable
        private String text;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        @Nullable
        private String botId;
        @Nullable
        private SlackMessageSubtype subtype;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSlackEventBotMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackEventMessageBase && (subtypeOptional = ((SlackEventMessageBase)(instance = (SlackEventMessageBase)object)).getSubtype()).isPresent()) {
                this.setSubtype(subtypeOptional);
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
                this.setTs(instance.getTs());
            }
            if (object instanceof AbstractSlackEventBotMessage) {
                instance = (AbstractSlackEventBotMessage)object;
                this.addAllAttachments(((AbstractSlackEventBotMessage)instance).getAttachments());
                Optional<String> textOptional = ((AbstractSlackEventBotMessage)instance).getText();
                if (textOptional.isPresent()) {
                    this.setText(textOptional);
                }
                this.setBotId(((AbstractSlackEventBotMessage)instance).getBotId());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(((AbstractSlackEventBotMessage)instance).getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder setBotId(String botId) {
            this.botId = Objects.requireNonNull(botId, "botId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public SlackEventBotMessage build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackEventBotMessage(this.channelId, this.text, SlackEventBotMessage.createUnmodifiableList(true, this.attachments), this.botId, this.subtype, this.type, this.ts);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean botIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.botIdIsSet()) {
                attributes.add("botId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build SlackEventBotMessage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractSlackEventBotMessage {
        @Nullable
        String channelId;
        Optional<String> text = Optional.empty();
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        String botId;
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setBotId(String botId) {
            this.botId = botId;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }
    }
}

