/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.events.AbstractSlackEventMessageDeleted;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackEventMessageDeleted
extends AbstractSlackEventMessageDeleted {
    private final String channelId;
    @Nullable
    private final LiteMessage previousMessage;
    private final boolean hidden;
    private final String deletedTs;
    private final String eventTs;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final SlackEventType type;
    private final String ts;

    private SlackEventMessageDeleted(String channelId, @Nullable LiteMessage previousMessage, boolean hidden, String deletedTs, String eventTs, @Nullable SlackMessageSubtype subtype, SlackEventType type, String ts) {
        this.channelId = channelId;
        this.previousMessage = previousMessage;
        this.hidden = hidden;
        this.deletedTs = deletedTs;
        this.eventTs = eventTs;
        this.subtype = subtype;
        this.type = type;
        this.ts = ts;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<LiteMessage> getPreviousMessage() {
        return Optional.ofNullable(this.previousMessage);
    }

    @Override
    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @JsonProperty
    public String getDeletedTs() {
        return this.deletedTs;
    }

    @Override
    @JsonProperty
    public String getEventTs() {
        return this.eventTs;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    public final SlackEventMessageDeleted withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlackEventMessageDeleted(newValue, this.previousMessage, this.hidden, this.deletedTs, this.eventTs, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageDeleted withPreviousMessage(@Nullable LiteMessage value) {
        LiteMessage newValue = value;
        if (this.previousMessage == newValue) {
            return this;
        }
        return new SlackEventMessageDeleted(this.channelId, newValue, this.hidden, this.deletedTs, this.eventTs, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageDeleted withPreviousMessage(Optional<LiteMessage> optional) {
        LiteMessage value = optional.orElse(null);
        if (this.previousMessage == value) {
            return this;
        }
        return new SlackEventMessageDeleted(this.channelId, value, this.hidden, this.deletedTs, this.eventTs, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageDeleted withHidden(boolean hidden) {
        if (this.hidden == hidden) {
            return this;
        }
        return new SlackEventMessageDeleted(this.channelId, this.previousMessage, hidden, this.deletedTs, this.eventTs, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageDeleted withDeletedTs(String deletedTs) {
        if (this.deletedTs.equals(deletedTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(deletedTs, "deletedTs");
        return new SlackEventMessageDeleted(this.channelId, this.previousMessage, this.hidden, newValue, this.eventTs, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageDeleted withEventTs(String eventTs) {
        if (this.eventTs.equals(eventTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(eventTs, "eventTs");
        return new SlackEventMessageDeleted(this.channelId, this.previousMessage, this.hidden, this.deletedTs, newValue, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageDeleted withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (Objects.equals((Object)this.subtype, (Object)newValue)) {
            return this;
        }
        return new SlackEventMessageDeleted(this.channelId, this.previousMessage, this.hidden, this.deletedTs, this.eventTs, newValue, this.type, this.ts);
    }

    public final SlackEventMessageDeleted withSubtype(Optional<SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (Objects.equals((Object)this.subtype, (Object)value)) {
            return this;
        }
        return new SlackEventMessageDeleted(this.channelId, this.previousMessage, this.hidden, this.deletedTs, this.eventTs, value, this.type, this.ts);
    }

    public final SlackEventMessageDeleted withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackEventMessageDeleted(this.channelId, this.previousMessage, this.hidden, this.deletedTs, this.eventTs, this.subtype, newValue, this.ts);
    }

    public final SlackEventMessageDeleted withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new SlackEventMessageDeleted(this.channelId, this.previousMessage, this.hidden, this.deletedTs, this.eventTs, this.subtype, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventMessageDeleted && this.equalTo((SlackEventMessageDeleted)another);
    }

    private boolean equalTo(SlackEventMessageDeleted another) {
        return this.channelId.equals(another.channelId) && Objects.equals(this.previousMessage, another.previousMessage) && this.hidden == another.hidden && this.deletedTs.equals(another.deletedTs) && this.eventTs.equals(another.eventTs) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.type.equals((Object)another.type) && this.ts.equals(another.ts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + Objects.hashCode(this.previousMessage);
        h = h * 17 + Boolean.hashCode(this.hidden);
        h = h * 17 + this.deletedTs.hashCode();
        h = h * 17 + this.eventTs.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.subtype);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.ts.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventMessageDeleted{");
        builder.append("channelId=").append(this.channelId);
        if (this.previousMessage != null) {
            builder.append(", ");
            builder.append("previousMessage=").append(this.previousMessage);
        }
        builder.append(", ");
        builder.append("hidden=").append(this.hidden);
        builder.append(", ");
        builder.append("deletedTs=").append(this.deletedTs);
        builder.append(", ");
        builder.append("eventTs=").append(this.eventTs);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackEventMessageDeleted fromJson(Json json) {
        Builder builder = SlackEventMessageDeleted.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.previousMessage != null) {
            builder.setPreviousMessage(json.previousMessage);
        }
        if (json.hiddenIsSet) {
            builder.setHidden(json.hidden);
        }
        if (json.deletedTs != null) {
            builder.setDeletedTs(json.deletedTs);
        }
        if (json.eventTs != null) {
            builder.setEventTs(json.eventTs);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        return builder.build();
    }

    public static SlackEventMessageDeleted copyOf(AbstractSlackEventMessageDeleted instance) {
        if (instance instanceof SlackEventMessageDeleted) {
            return (SlackEventMessageDeleted)instance;
        }
        return SlackEventMessageDeleted.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_HIDDEN = 2L;
        private static final long INIT_BIT_DELETED_TS = 4L;
        private static final long INIT_BIT_EVENT_TS = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private static final long INIT_BIT_TS = 32L;
        private long initBits = 63L;
        @Nullable
        private String channelId;
        @Nullable
        private LiteMessage previousMessage;
        private boolean hidden;
        @Nullable
        private String deletedTs;
        @Nullable
        private String eventTs;
        @Nullable
        private SlackMessageSubtype subtype;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSlackEventMessageDeleted instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackEventMessageBase && (subtypeOptional = ((SlackEventMessageBase)(instance = (SlackEventMessageBase)object)).getSubtype()).isPresent()) {
                this.setSubtype(subtypeOptional);
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
                this.setTs(instance.getTs());
            }
            if (object instanceof AbstractSlackEventMessageDeleted) {
                instance = (AbstractSlackEventMessageDeleted)object;
                this.setHidden(((AbstractSlackEventMessageDeleted)instance).isHidden());
                Optional<LiteMessage> previousMessageOptional = ((AbstractSlackEventMessageDeleted)instance).getPreviousMessage();
                if (previousMessageOptional.isPresent()) {
                    this.setPreviousMessage(previousMessageOptional);
                }
                this.setEventTs(((AbstractSlackEventMessageDeleted)instance).getEventTs());
                this.setDeletedTs(((AbstractSlackEventMessageDeleted)instance).getDeletedTs());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(((AbstractSlackEventMessageDeleted)instance).getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPreviousMessage(@Nullable LiteMessage previousMessage) {
            this.previousMessage = previousMessage;
            return this;
        }

        public final Builder setPreviousMessage(Optional<LiteMessage> previousMessage) {
            this.previousMessage = previousMessage.orElse(null);
            return this;
        }

        public final Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setDeletedTs(String deletedTs) {
            this.deletedTs = Objects.requireNonNull(deletedTs, "deletedTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setEventTs(String eventTs) {
            this.eventTs = Objects.requireNonNull(eventTs, "eventTs");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public SlackEventMessageDeleted build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackEventMessageDeleted(this.channelId, this.previousMessage, this.hidden, this.deletedTs, this.eventTs, this.subtype, this.type, this.ts);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean hiddenIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean deletedTsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean eventTsIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.hiddenIsSet()) {
                attributes.add("hidden");
            }
            if (!this.deletedTsIsSet()) {
                attributes.add("deletedTs");
            }
            if (!this.eventTsIsSet()) {
                attributes.add("eventTs");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build SlackEventMessageDeleted, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractSlackEventMessageDeleted {
        @Nullable
        String channelId;
        Optional<LiteMessage> previousMessage = Optional.empty();
        boolean hidden;
        boolean hiddenIsSet;
        @Nullable
        String deletedTs;
        @Nullable
        String eventTs;
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setPreviousMessage(Optional<LiteMessage> previousMessage) {
            this.previousMessage = previousMessage;
        }

        @JsonProperty
        public void setHidden(boolean hidden) {
            this.hidden = hidden;
            this.hiddenIsSet = true;
        }

        @JsonProperty
        public void setDeletedTs(String deletedTs) {
            this.deletedTs = deletedTs;
        }

        @JsonProperty
        public void setEventTs(String eventTs) {
            this.eventTs = eventTs;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LiteMessage> getPreviousMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHidden() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDeletedTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEventTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }
    }
}

