/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.app;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.app.SlackAppUninstalledEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackAppUninstalledEvent
implements SlackAppUninstalledEventIF {
    private final SlackEventType type;

    private SlackAppUninstalledEvent(SlackEventType type) {
        this.type = type;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    public final SlackAppUninstalledEvent withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackAppUninstalledEvent(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackAppUninstalledEvent && this.equalTo((SlackAppUninstalledEvent)another);
    }

    private boolean equalTo(SlackAppUninstalledEvent another) {
        return this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "SlackAppUninstalledEvent{type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackAppUninstalledEvent fromJson(Json json) {
        Builder builder = SlackAppUninstalledEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static SlackAppUninstalledEvent copyOf(SlackAppUninstalledEventIF instance) {
        if (instance instanceof SlackAppUninstalledEvent) {
            return (SlackAppUninstalledEvent)instance;
        }
        return SlackAppUninstalledEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private SlackEventType type;

        private Builder() {
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackAppUninstalledEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof SlackEvent) {
                SlackEvent instance = (SlackEvent)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public SlackAppUninstalledEvent build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackAppUninstalledEvent(this.type);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build SlackAppUninstalledEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackAppUninstalledEventIF {
        @Nullable
        SlackEventType type;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

