/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.links;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.links.LinkIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Link
implements LinkIF {
    private final String domain;
    private final String url;

    private Link(String domain, String url) {
        this.domain = domain;
        this.url = url;
    }

    @Override
    @JsonProperty
    public String getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    public final Link withDomain(String domain) {
        if (this.domain.equals(domain)) {
            return this;
        }
        String newValue = Objects.requireNonNull(domain, "domain");
        return new Link(newValue, this.url);
    }

    public final Link withUrl(String url) {
        if (this.url.equals(url)) {
            return this;
        }
        String newValue = Objects.requireNonNull(url, "url");
        return new Link(this.domain, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Link && this.equalTo((Link)another);
    }

    private boolean equalTo(Link another) {
        return this.domain.equals(another.domain) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "Link{domain=" + this.domain + ", url=" + this.url + "}";
    }

    @Deprecated
    @JsonCreator
    static Link fromJson(Json json) {
        Builder builder = Link.builder();
        if (json.domain != null) {
            builder.setDomain(json.domain);
        }
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        return builder.build();
    }

    public static Link copyOf(LinkIF instance) {
        if (instance instanceof Link) {
            return (Link)instance;
        }
        return Link.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DOMAIN = 1L;
        private static final long INIT_BIT_URL = 2L;
        private long initBits = 3L;
        @Nullable
        private String domain;
        @Nullable
        private String url;

        private Builder() {
        }

        public final Builder from(LinkIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setDomain(instance.getDomain());
            this.setUrl(instance.getUrl());
            return this;
        }

        public final Builder setDomain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUrl(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Link build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Link(this.domain, this.url);
        }

        private boolean domainIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean urlIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.domainIsSet()) {
                attributes.add("domain");
            }
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            return "Cannot build Link, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements LinkIF {
        @Nullable
        String domain;
        @Nullable
        String url;

        Json() {
        }

        @JsonProperty
        public void setDomain(String domain) {
            this.domain = domain;
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public String getDomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

