/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.user;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ChannelType;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.user.SlackMemberLeftChannelEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackMemberLeftChannelEvent
implements SlackMemberLeftChannelEventIF {
    private final String userId;
    private final String channelId;
    private final ChannelType channelType;
    private final String team;
    private final SlackEventType type;

    private SlackMemberLeftChannelEvent(String userId, String channelId, ChannelType channelType, String team, SlackEventType type) {
        this.userId = userId;
        this.channelId = channelId;
        this.channelType = channelType;
        this.team = team;
        this.type = type;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public ChannelType getChannelType() {
        return this.channelType;
    }

    @Override
    @JsonProperty
    public String getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    public final SlackMemberLeftChannelEvent withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new SlackMemberLeftChannelEvent(newValue, this.channelId, this.channelType, this.team, this.type);
    }

    public final SlackMemberLeftChannelEvent withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlackMemberLeftChannelEvent(this.userId, newValue, this.channelType, this.team, this.type);
    }

    public final SlackMemberLeftChannelEvent withChannelType(ChannelType channelType) {
        if (this.channelType == channelType) {
            return this;
        }
        ChannelType newValue = Objects.requireNonNull(channelType, "channelType");
        return new SlackMemberLeftChannelEvent(this.userId, this.channelId, newValue, this.team, this.type);
    }

    public final SlackMemberLeftChannelEvent withTeam(String team) {
        if (this.team.equals(team)) {
            return this;
        }
        String newValue = Objects.requireNonNull(team, "team");
        return new SlackMemberLeftChannelEvent(this.userId, this.channelId, this.channelType, newValue, this.type);
    }

    public final SlackMemberLeftChannelEvent withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackMemberLeftChannelEvent(this.userId, this.channelId, this.channelType, this.team, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackMemberLeftChannelEvent && this.equalTo((SlackMemberLeftChannelEvent)another);
    }

    private boolean equalTo(SlackMemberLeftChannelEvent another) {
        return this.userId.equals(another.userId) && this.channelId.equals(another.channelId) && this.channelType.equals((Object)another.channelType) && this.team.equals(another.team) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + this.channelType.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "SlackMemberLeftChannelEvent{userId=" + this.userId + ", channelId=" + this.channelId + ", channelType=" + (Object)((Object)this.channelType) + ", team=" + this.team + ", type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackMemberLeftChannelEvent fromJson(Json json) {
        Builder builder = SlackMemberLeftChannelEvent.builder();
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.channelType != null) {
            builder.setChannelType(json.channelType);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static SlackMemberLeftChannelEvent copyOf(SlackMemberLeftChannelEventIF instance) {
        if (instance instanceof SlackMemberLeftChannelEvent) {
            return (SlackMemberLeftChannelEvent)instance;
        }
        return SlackMemberLeftChannelEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_CHANNEL_TYPE = 4L;
        private static final long INIT_BIT_TEAM = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private long initBits = 31L;
        @Nullable
        private String userId;
        @Nullable
        private String channelId;
        @Nullable
        private ChannelType channelType;
        @Nullable
        private String team;
        @Nullable
        private SlackEventType type;

        private Builder() {
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackMemberLeftChannelEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackEvent instance;
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
            }
            if (object instanceof SlackMemberLeftChannelEventIF) {
                instance = (SlackMemberLeftChannelEventIF)object;
                this.setChannelType(instance.getChannelType());
                this.setTeam(instance.getTeam());
                this.setUserId(instance.getUserId());
                this.setChannelId(instance.getChannelId());
            }
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannelType(ChannelType channelType) {
            this.channelType = Objects.requireNonNull(channelType, "channelType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTeam(String team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public SlackMemberLeftChannelEvent build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackMemberLeftChannelEvent(this.userId, this.channelId, this.channelType, this.team, this.type);
        }

        private boolean userIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelTypeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.channelTypeIsSet()) {
                attributes.add("channelType");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build SlackMemberLeftChannelEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackMemberLeftChannelEventIF {
        @Nullable
        String userId;
        @Nullable
        String channelId;
        @Nullable
        ChannelType channelType;
        @Nullable
        String team;
        @Nullable
        SlackEventType type;

        Json() {
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setChannelType(ChannelType channelType) {
            this.channelType = channelType;
        }

        @JsonProperty
        public void setTeam(String team) {
            this.team = team;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelType getChannelType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

