/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import com.hubspot.slack.client.models.interaction.BlockElementActionIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class BlockElementAction
implements BlockElementActionIF {
    private final String blockId;
    private final String actionId;
    private final BlockElement element;
    @Nullable
    private final String selectedValue;
    @Nullable
    private final LocalDate selectedDate;
    @Nullable
    private final String actionTs;

    private BlockElementAction(String blockId, String actionId, BlockElement element, @Nullable String selectedValue, @Nullable LocalDate selectedDate, @Nullable String actionTs) {
        this.blockId = blockId;
        this.actionId = actionId;
        this.element = element;
        this.selectedValue = selectedValue;
        this.selectedDate = selectedDate;
        this.actionTs = actionTs;
    }

    @Override
    @JsonProperty
    public String getBlockId() {
        return this.blockId;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public BlockElement getElement() {
        return this.element;
    }

    @Override
    @JsonProperty
    public Optional<String> getSelectedValue() {
        return Optional.ofNullable(this.selectedValue);
    }

    @Override
    @JsonProperty(value="selected_date")
    public Optional<LocalDate> getSelectedDate() {
        return Optional.ofNullable(this.selectedDate);
    }

    @Override
    @JsonProperty
    public Optional<String> getActionTs() {
        return Optional.ofNullable(this.actionTs);
    }

    public final BlockElementAction withBlockId(String blockId) {
        if (this.blockId.equals(blockId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(blockId, "blockId");
        return new BlockElementAction(newValue, this.actionId, this.element, this.selectedValue, this.selectedDate, this.actionTs);
    }

    public final BlockElementAction withActionId(String actionId) {
        if (this.actionId.equals(actionId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionId, "actionId");
        return new BlockElementAction(this.blockId, newValue, this.element, this.selectedValue, this.selectedDate, this.actionTs);
    }

    public final BlockElementAction withElement(BlockElement element) {
        if (this.element == element) {
            return this;
        }
        BlockElement newValue = Objects.requireNonNull(element, "element");
        return new BlockElementAction(this.blockId, this.actionId, newValue, this.selectedValue, this.selectedDate, this.actionTs);
    }

    public final BlockElementAction withSelectedValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.selectedValue, newValue)) {
            return this;
        }
        return new BlockElementAction(this.blockId, this.actionId, this.element, newValue, this.selectedDate, this.actionTs);
    }

    public final BlockElementAction withSelectedValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.selectedValue, value)) {
            return this;
        }
        return new BlockElementAction(this.blockId, this.actionId, this.element, value, this.selectedDate, this.actionTs);
    }

    public final BlockElementAction withSelectedDate(@Nullable LocalDate value) {
        LocalDate newValue = value;
        if (this.selectedDate == newValue) {
            return this;
        }
        return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, newValue, this.actionTs);
    }

    public final BlockElementAction withSelectedDate(Optional<LocalDate> optional) {
        LocalDate value = optional.orElse(null);
        if (this.selectedDate == value) {
            return this;
        }
        return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, value, this.actionTs);
    }

    public final BlockElementAction withActionTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.actionTs, newValue)) {
            return this;
        }
        return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, this.selectedDate, newValue);
    }

    public final BlockElementAction withActionTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.actionTs, value)) {
            return this;
        }
        return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, this.selectedDate, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BlockElementAction && this.equalTo((BlockElementAction)another);
    }

    private boolean equalTo(BlockElementAction another) {
        return this.blockId.equals(another.blockId) && this.actionId.equals(another.actionId) && this.element.equals(another.element) && Objects.equals(this.selectedValue, another.selectedValue) && Objects.equals(this.selectedDate, another.selectedDate) && Objects.equals(this.actionTs, another.actionTs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.blockId.hashCode();
        h = h * 17 + this.actionId.hashCode();
        h = h * 17 + this.element.hashCode();
        h = h * 17 + Objects.hashCode(this.selectedValue);
        h = h * 17 + Objects.hashCode(this.selectedDate);
        h = h * 17 + Objects.hashCode(this.actionTs);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BlockElementAction{");
        builder.append("blockId=").append(this.blockId);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("element=").append(this.element);
        if (this.selectedValue != null) {
            builder.append(", ");
            builder.append("selectedValue=").append(this.selectedValue);
        }
        if (this.selectedDate != null) {
            builder.append(", ");
            builder.append("selectedDate=").append(this.selectedDate);
        }
        if (this.actionTs != null) {
            builder.append(", ");
            builder.append("actionTs=").append(this.actionTs);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static BlockElementAction fromJson(Json json) {
        Builder builder = BlockElementAction.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.element != null) {
            builder.setElement(json.element);
        }
        if (json.selectedValue != null) {
            builder.setSelectedValue(json.selectedValue);
        }
        if (json.selectedDate != null) {
            builder.setSelectedDate(json.selectedDate);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        return builder.build();
    }

    public static BlockElementAction copyOf(BlockElementActionIF instance) {
        if (instance instanceof BlockElementAction) {
            return (BlockElementAction)instance;
        }
        return BlockElementAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BLOCK_ID = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private static final long INIT_BIT_ELEMENT = 4L;
        private long initBits = 7L;
        @Nullable
        private String blockId;
        @Nullable
        private String actionId;
        @Nullable
        private BlockElement element;
        @Nullable
        private String selectedValue;
        @Nullable
        private LocalDate selectedDate;
        @Nullable
        private String actionTs;

        private Builder() {
        }

        public final Builder from(BlockElementActionIF instance) {
            Optional<String> actionTsOptional;
            Optional<LocalDate> selectedDateOptional;
            Objects.requireNonNull(instance, "instance");
            this.setBlockId(instance.getBlockId());
            this.setActionId(instance.getActionId());
            this.setElement(instance.getElement());
            Optional<String> selectedValueOptional = instance.getSelectedValue();
            if (selectedValueOptional.isPresent()) {
                this.setSelectedValue(selectedValueOptional);
            }
            if ((selectedDateOptional = instance.getSelectedDate()).isPresent()) {
                this.setSelectedDate(selectedDateOptional);
            }
            if ((actionTsOptional = instance.getActionTs()).isPresent()) {
                this.setActionTs(actionTsOptional);
            }
            return this;
        }

        public final Builder setBlockId(String blockId) {
            this.blockId = Objects.requireNonNull(blockId, "blockId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setElement(BlockElement element) {
            this.element = Objects.requireNonNull(element, "element");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setSelectedValue(@Nullable String selectedValue) {
            this.selectedValue = selectedValue;
            return this;
        }

        public final Builder setSelectedValue(Optional<String> selectedValue) {
            this.selectedValue = selectedValue.orElse(null);
            return this;
        }

        public final Builder setSelectedDate(@Nullable LocalDate selectedDate) {
            this.selectedDate = selectedDate;
            return this;
        }

        public final Builder setSelectedDate(Optional<LocalDate> selectedDate) {
            this.selectedDate = selectedDate.orElse(null);
            return this;
        }

        public final Builder setActionTs(@Nullable String actionTs) {
            this.actionTs = actionTs;
            return this;
        }

        public final Builder setActionTs(Optional<String> actionTs) {
            this.actionTs = actionTs.orElse(null);
            return this;
        }

        public BlockElementAction build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, this.selectedDate, this.actionTs);
        }

        private boolean blockIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean elementIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.blockIdIsSet()) {
                attributes.add("blockId");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            if (!this.elementIsSet()) {
                attributes.add("element");
            }
            return "Cannot build BlockElementAction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BlockElementActionIF {
        @Nullable
        String blockId;
        @Nullable
        String actionId;
        @Nullable
        BlockElement element;
        Optional<String> selectedValue = Optional.empty();
        Optional<LocalDate> selectedDate = Optional.empty();
        Optional<String> actionTs = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setBlockId(String blockId) {
            this.blockId = blockId;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setElement(BlockElement element) {
            this.element = element;
        }

        @JsonProperty
        public void setSelectedValue(Optional<String> selectedValue) {
            this.selectedValue = selectedValue;
        }

        @JsonProperty(value="selected_date")
        public void setSelectedDate(Optional<LocalDate> selectedDate) {
            this.selectedDate = selectedDate;
        }

        @JsonProperty
        public void setActionTs(Optional<String> actionTs) {
            this.actionTs = actionTs;
        }

        @Override
        public String getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockElement getElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSelectedValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LocalDate> getSelectedDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getActionTs() {
            throw new UnsupportedOperationException();
        }
    }
}

