/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.interaction.DialogSubmissionIF;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class DialogSubmission
implements DialogSubmissionIF {
    private final Map<String, Optional<String>> submission;
    @Nullable
    private final String state;
    private final InteractiveCallbackType type;
    private final String callbackId;
    private final String actionTs;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;
    private final SlackChannel channel;

    private DialogSubmission(Map<String, Optional<String>> submission, @Nullable String state, InteractiveCallbackType type, String callbackId, String actionTs, String token, SlackTeam team, SlackUserLite user, SlackChannel channel) {
        this.submission = submission;
        this.state = state;
        this.type = type;
        this.callbackId = callbackId;
        this.actionTs = actionTs;
        this.token = token;
        this.team = team;
        this.user = user;
        this.channel = channel;
    }

    @Override
    @JsonProperty
    public Map<String, Optional<String>> getSubmission() {
        return this.submission;
    }

    @Override
    @JsonProperty
    public Optional<String> getState() {
        return Optional.ofNullable(this.state);
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    public final DialogSubmission withSubmission(Map<String, ? extends Optional<String>> submission) {
        if (this.submission == submission) {
            return this;
        }
        Map<String, Optional<String>> newValue = DialogSubmission.createUnmodifiableMap(true, false, submission);
        return new DialogSubmission(newValue, this.state, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final DialogSubmission withState(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.state, newValue)) {
            return this;
        }
        return new DialogSubmission(this.submission, newValue, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final DialogSubmission withState(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new DialogSubmission(this.submission, value, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final DialogSubmission withType(InteractiveCallbackType type) {
        if (this.type == type) {
            return this;
        }
        InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
        return new DialogSubmission(this.submission, this.state, newValue, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final DialogSubmission withCallbackId(String callbackId) {
        if (this.callbackId.equals(callbackId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(callbackId, "callbackId");
        return new DialogSubmission(this.submission, this.state, this.type, newValue, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final DialogSubmission withActionTs(String actionTs) {
        if (this.actionTs.equals(actionTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionTs, "actionTs");
        return new DialogSubmission(this.submission, this.state, this.type, this.callbackId, newValue, this.token, this.team, this.user, this.channel);
    }

    public final DialogSubmission withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new DialogSubmission(this.submission, this.state, this.type, this.callbackId, this.actionTs, newValue, this.team, this.user, this.channel);
    }

    public final DialogSubmission withTeam(SlackTeam team) {
        if (this.team == team) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(team, "team");
        return new DialogSubmission(this.submission, this.state, this.type, this.callbackId, this.actionTs, this.token, newValue, this.user, this.channel);
    }

    public final DialogSubmission withUser(SlackUserLite user) {
        if (this.user == user) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(user, "user");
        return new DialogSubmission(this.submission, this.state, this.type, this.callbackId, this.actionTs, this.token, this.team, newValue, this.channel);
    }

    public final DialogSubmission withChannel(SlackChannel channel) {
        if (this.channel == channel) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(channel, "channel");
        return new DialogSubmission(this.submission, this.state, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DialogSubmission && this.equalTo((DialogSubmission)another);
    }

    private boolean equalTo(DialogSubmission another) {
        return this.submission.equals(another.submission) && Objects.equals(this.state, another.state) && this.type.equals((Object)another.type) && this.callbackId.equals(another.callbackId) && this.actionTs.equals(another.actionTs) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.submission.hashCode();
        h = h * 17 + Objects.hashCode(this.state);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.callbackId.hashCode();
        h = h * 17 + this.actionTs.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.user.hashCode();
        h = h * 17 + this.channel.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DialogSubmission{");
        builder.append("submission=").append(this.submission);
        if (this.state != null) {
            builder.append(", ");
            builder.append("state=").append(this.state);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("callbackId=").append(this.callbackId);
        builder.append(", ");
        builder.append("actionTs=").append(this.actionTs);
        builder.append(", ");
        builder.append("token=").append(this.token);
        builder.append(", ");
        builder.append("team=").append(this.team);
        builder.append(", ");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static DialogSubmission fromJson(Json json) {
        Builder builder = DialogSubmission.builder();
        if (json.submission != null) {
            builder.putAllSubmission(json.submission);
        }
        if (json.state != null) {
            builder.setState(json.state);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        return builder.build();
    }

    public static DialogSubmission copyOf(DialogSubmissionIF instance) {
        if (instance instanceof DialogSubmission) {
            return (DialogSubmission)instance;
        }
        return DialogSubmission.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CALLBACK_ID = 2L;
        private static final long INIT_BIT_ACTION_TS = 4L;
        private static final long INIT_BIT_TOKEN = 8L;
        private static final long INIT_BIT_TEAM = 16L;
        private static final long INIT_BIT_USER = 32L;
        private static final long INIT_BIT_CHANNEL = 64L;
        private long initBits = 127L;
        private Map<String, Optional<String>> submission = new LinkedHashMap<String, Optional<String>>();
        @Nullable
        private String state;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String callbackId;
        @Nullable
        private String actionTs;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private SlackChannel channel;

        private Builder() {
        }

        public final Builder from(DialogSubmissionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackInteractiveCallback instance;
            if (object instanceof DialogSubmissionIF) {
                instance = (DialogSubmissionIF)object;
                this.putAllSubmission(instance.getSubmission());
                Optional<String> stateOptional = instance.getState();
                if (stateOptional.isPresent()) {
                    this.setState(stateOptional);
                }
            }
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                this.setCallbackId(instance.getCallbackId());
                this.setChannel(instance.getChannel());
                this.setTeam(instance.getTeam());
                this.setType(instance.getType());
                this.setActionTs(instance.getActionTs());
                this.setUser(instance.getUser());
                this.setToken(instance.getToken());
            }
        }

        public final Builder putSubmission(String key, Optional<String> value) {
            this.submission.put(Objects.requireNonNull(key, "submission key"), Objects.requireNonNull(value, "submission value"));
            return this;
        }

        public final Builder putSubmission(Map.Entry<String, ? extends Optional<String>> entry) {
            String k = entry.getKey();
            Optional<String> v = entry.getValue();
            this.submission.put(Objects.requireNonNull(k, "submission key"), Objects.requireNonNull(v, "submission value"));
            return this;
        }

        public final Builder setSubmission(Map<String, ? extends Optional<String>> submission) {
            this.submission.clear();
            return this.putAllSubmission(submission);
        }

        public final Builder putAllSubmission(Map<String, ? extends Optional<String>> submission) {
            for (Map.Entry<String, ? extends Optional<String>> entry : submission.entrySet()) {
                String k = entry.getKey();
                Optional<String> v = entry.getValue();
                this.submission.put(Objects.requireNonNull(k, "submission key"), Objects.requireNonNull(v, "submission value"));
            }
            return this;
        }

        public final Builder setState(@Nullable String state) {
            this.state = state;
            return this;
        }

        public final Builder setState(Optional<String> state) {
            this.state = state.orElse(null);
            return this;
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public DialogSubmission build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new DialogSubmission(DialogSubmission.createUnmodifiableMap(false, false, this.submission), this.state, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            return "Cannot build DialogSubmission, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements DialogSubmissionIF {
        @Nullable
        Map<String, Optional<String>> submission;
        Optional<String> state = Optional.empty();
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String callbackId;
        @Nullable
        String actionTs;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;
        @Nullable
        SlackChannel channel;

        Json() {
        }

        @JsonProperty
        public void setSubmission(Map<String, Optional<String>> submission) {
            this.submission = submission;
        }

        @JsonProperty
        public void setState(Optional<String> state) {
            this.state = state;
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @Override
        public Map<String, Optional<String>> getSubmission() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }
    }
}

