/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.Container;
import com.hubspot.slack.client.models.interaction.ContainerType;
import com.hubspot.slack.client.models.interaction.MessageContainerIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class MessageContainer
implements MessageContainerIF {
    private final String messageTs;
    private final String channelId;
    private final boolean ephemeral;
    private final ContainerType type;

    private MessageContainer(String messageTs, String channelId, boolean ephemeral, ContainerType type) {
        this.messageTs = messageTs;
        this.channelId = channelId;
        this.ephemeral = ephemeral;
        this.type = type;
    }

    @Override
    @JsonProperty
    public String getMessageTs() {
        return this.messageTs;
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="is_ephemeral")
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    @Override
    @JsonProperty
    public ContainerType getType() {
        return this.type;
    }

    public final MessageContainer withMessageTs(String messageTs) {
        if (this.messageTs.equals(messageTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(messageTs, "messageTs");
        return new MessageContainer(newValue, this.channelId, this.ephemeral, this.type);
    }

    public final MessageContainer withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new MessageContainer(this.messageTs, newValue, this.ephemeral, this.type);
    }

    public final MessageContainer withEphemeral(boolean ephemeral) {
        if (this.ephemeral == ephemeral) {
            return this;
        }
        return new MessageContainer(this.messageTs, this.channelId, ephemeral, this.type);
    }

    public final MessageContainer withType(ContainerType type) {
        if (this.type == type) {
            return this;
        }
        ContainerType newValue = Objects.requireNonNull(type, "type");
        return new MessageContainer(this.messageTs, this.channelId, this.ephemeral, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageContainer && this.equalTo((MessageContainer)another);
    }

    private boolean equalTo(MessageContainer another) {
        return this.messageTs.equals(another.messageTs) && this.channelId.equals(another.channelId) && this.ephemeral == another.ephemeral && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.messageTs.hashCode();
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + Boolean.hashCode(this.ephemeral);
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "MessageContainer{messageTs=" + this.messageTs + ", channelId=" + this.channelId + ", ephemeral=" + this.ephemeral + ", type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static MessageContainer fromJson(Json json) {
        Builder builder = MessageContainer.builder();
        if (json.messageTs != null) {
            builder.setMessageTs(json.messageTs);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.ephemeralIsSet) {
            builder.setEphemeral(json.ephemeral);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static MessageContainer copyOf(MessageContainerIF instance) {
        if (instance instanceof MessageContainer) {
            return (MessageContainer)instance;
        }
        return MessageContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE_TS = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_EPHEMERAL = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private long initBits = 15L;
        @Nullable
        private String messageTs;
        @Nullable
        private String channelId;
        private boolean ephemeral;
        @Nullable
        private ContainerType type;

        private Builder() {
        }

        public final Builder from(MessageContainerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Container instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Container instance;
            if (object instanceof MessageContainerIF) {
                instance = (MessageContainerIF)object;
                this.setEphemeral(instance.isEphemeral());
                this.setMessageTs(instance.getMessageTs());
                this.setChannelId(instance.getChannelId());
            }
            if (object instanceof Container) {
                instance = (Container)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setMessageTs(String messageTs) {
            this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setEphemeral(boolean ephemeral) {
            this.ephemeral = ephemeral;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setType(ContainerType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public MessageContainer build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new MessageContainer(this.messageTs, this.channelId, this.ephemeral, this.type);
        }

        private boolean messageTsIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean ephemeralIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.messageTsIsSet()) {
                attributes.add("messageTs");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.ephemeralIsSet()) {
                attributes.add("ephemeral");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build MessageContainer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageContainerIF {
        @Nullable
        String messageTs;
        @Nullable
        String channelId;
        boolean ephemeral;
        boolean ephemeralIsSet;
        @Nullable
        ContainerType type;

        Json() {
        }

        @JsonProperty
        public void setMessageTs(String messageTs) {
            this.messageTs = messageTs;
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="is_ephemeral")
        public void setEphemeral(boolean ephemeral) {
            this.ephemeral = ephemeral;
            this.ephemeralIsSet = true;
        }

        @JsonProperty
        public void setType(ContainerType type) {
            this.type = type;
        }

        @Override
        public String getMessageTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEphemeral() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContainerType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

