/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.actions.Option;
import com.hubspot.slack.client.models.interaction.OptionsListIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class OptionsList
implements OptionsListIF {
    private final List<Option> options;

    private OptionsList(List<Option> options) {
        this.options = options;
    }

    @Override
    @JsonProperty
    public List<Option> getOptions() {
        return this.options;
    }

    public final OptionsList withOptions(Option ... elements) {
        List<Option> newValue = OptionsList.createUnmodifiableList(false, OptionsList.createSafeList(Arrays.asList(elements), true, false));
        return new OptionsList(newValue);
    }

    public final OptionsList withOptions(Iterable<? extends Option> elements) {
        if (this.options == elements) {
            return this;
        }
        List<Option> newValue = OptionsList.createUnmodifiableList(false, OptionsList.createSafeList(elements, true, false));
        return new OptionsList(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OptionsList && this.equalTo((OptionsList)another);
    }

    private boolean equalTo(OptionsList another) {
        return this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.options.hashCode();
        return h;
    }

    public String toString() {
        return "OptionsList{options=" + this.options + "}";
    }

    @Deprecated
    @JsonCreator
    static OptionsList fromJson(Json json) {
        Builder builder = OptionsList.builder();
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        return builder.build();
    }

    public static OptionsList copyOf(OptionsListIF instance) {
        if (instance instanceof OptionsList) {
            return (OptionsList)instance;
        }
        return OptionsList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private List<Option> options = new ArrayList<Option>();

        private Builder() {
        }

        public final Builder from(OptionsListIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllOptions(instance.getOptions());
            return this;
        }

        public final Builder addOptions(Option element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(Option ... elements) {
            for (Option element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends Option> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.options.add(Objects.requireNonNull(option, "options element"));
            }
            return this;
        }

        public OptionsList build() throws InvalidImmutableStateException {
            return new OptionsList(OptionsList.createUnmodifiableList(true, this.options));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OptionsListIF {
        List<Option> options = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOptions(List<Option> options) {
            this.options = options;
        }

        @Override
        public List<Option> getOptions() {
            throw new UnsupportedOperationException();
        }
    }
}

