/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.interaction.ViewClosedIF;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ViewClosed
implements ViewClosedIF {
    private final ViewPayloadBase view;
    private final boolean isCleared;
    private final InteractiveCallbackType type;
    private final String callbackId;
    private final String actionTs;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;
    private final SlackChannel channel;

    private ViewClosed(ViewPayloadBase view, boolean isCleared, InteractiveCallbackType type, String callbackId, String actionTs, String token, SlackTeam team, SlackUserLite user, SlackChannel channel) {
        this.view = view;
        this.isCleared = isCleared;
        this.type = type;
        this.callbackId = callbackId;
        this.actionTs = actionTs;
        this.token = token;
        this.team = team;
        this.user = user;
        this.channel = channel;
    }

    @Override
    @JsonProperty
    public ViewPayloadBase getView() {
        return this.view;
    }

    @Override
    @JsonProperty
    public boolean getIsCleared() {
        return this.isCleared;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    public final ViewClosed withView(ViewPayloadBase view) {
        if (this.view == view) {
            return this;
        }
        ViewPayloadBase newValue = Objects.requireNonNull(view, "view");
        return new ViewClosed(newValue, this.isCleared, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final ViewClosed withIsCleared(boolean isCleared) {
        if (this.isCleared == isCleared) {
            return this;
        }
        return new ViewClosed(this.view, isCleared, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final ViewClosed withType(InteractiveCallbackType type) {
        if (this.type == type) {
            return this;
        }
        InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
        return new ViewClosed(this.view, this.isCleared, newValue, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final ViewClosed withCallbackId(String callbackId) {
        if (this.callbackId.equals(callbackId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(callbackId, "callbackId");
        return new ViewClosed(this.view, this.isCleared, this.type, newValue, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final ViewClosed withActionTs(String actionTs) {
        if (this.actionTs.equals(actionTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionTs, "actionTs");
        return new ViewClosed(this.view, this.isCleared, this.type, this.callbackId, newValue, this.token, this.team, this.user, this.channel);
    }

    public final ViewClosed withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new ViewClosed(this.view, this.isCleared, this.type, this.callbackId, this.actionTs, newValue, this.team, this.user, this.channel);
    }

    public final ViewClosed withTeam(SlackTeam team) {
        if (this.team == team) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(team, "team");
        return new ViewClosed(this.view, this.isCleared, this.type, this.callbackId, this.actionTs, this.token, newValue, this.user, this.channel);
    }

    public final ViewClosed withUser(SlackUserLite user) {
        if (this.user == user) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(user, "user");
        return new ViewClosed(this.view, this.isCleared, this.type, this.callbackId, this.actionTs, this.token, this.team, newValue, this.channel);
    }

    public final ViewClosed withChannel(SlackChannel channel) {
        if (this.channel == channel) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(channel, "channel");
        return new ViewClosed(this.view, this.isCleared, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewClosed && this.equalTo((ViewClosed)another);
    }

    private boolean equalTo(ViewClosed another) {
        return this.view.equals(another.view) && this.isCleared == another.isCleared && this.type.equals((Object)another.type) && this.callbackId.equals(another.callbackId) && this.actionTs.equals(another.actionTs) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.view.hashCode();
        h = h * 17 + Boolean.hashCode(this.isCleared);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.callbackId.hashCode();
        h = h * 17 + this.actionTs.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.user.hashCode();
        h = h * 17 + this.channel.hashCode();
        return h;
    }

    public String toString() {
        return "ViewClosed{view=" + this.view + ", isCleared=" + this.isCleared + ", type=" + (Object)((Object)this.type) + ", callbackId=" + this.callbackId + ", actionTs=" + this.actionTs + ", token=" + this.token + ", team=" + this.team + ", user=" + this.user + ", channel=" + this.channel + "}";
    }

    @Deprecated
    @JsonCreator
    static ViewClosed fromJson(Json json) {
        Builder builder = ViewClosed.builder();
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.isClearedIsSet) {
            builder.setIsCleared(json.isCleared);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        return builder.build();
    }

    public static ViewClosed copyOf(ViewClosedIF instance) {
        if (instance instanceof ViewClosed) {
            return (ViewClosed)instance;
        }
        return ViewClosed.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VIEW = 1L;
        private static final long INIT_BIT_IS_CLEARED = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_CALLBACK_ID = 8L;
        private static final long INIT_BIT_ACTION_TS = 16L;
        private static final long INIT_BIT_TOKEN = 32L;
        private static final long INIT_BIT_TEAM = 64L;
        private static final long INIT_BIT_USER = 128L;
        private static final long INIT_BIT_CHANNEL = 256L;
        private long initBits = 511L;
        @Nullable
        private ViewPayloadBase view;
        private boolean isCleared;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String callbackId;
        @Nullable
        private String actionTs;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private SlackChannel channel;

        private Builder() {
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewClosedIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackInteractiveCallback instance;
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                this.setCallbackId(instance.getCallbackId());
                this.setChannel(instance.getChannel());
                this.setTeam(instance.getTeam());
                this.setType(instance.getType());
                this.setActionTs(instance.getActionTs());
                this.setUser(instance.getUser());
                this.setToken(instance.getToken());
            }
            if (object instanceof ViewClosedIF) {
                instance = (ViewClosedIF)object;
                this.setIsCleared(instance.getIsCleared());
                this.setView(instance.getView());
            }
        }

        public final Builder setView(ViewPayloadBase view) {
            this.view = Objects.requireNonNull(view, "view");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIsCleared(boolean isCleared) {
            this.isCleared = isCleared;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public ViewClosed build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ViewClosed(this.view, this.isCleared, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
        }

        private boolean viewIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean isClearedIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.viewIsSet()) {
                attributes.add("view");
            }
            if (!this.isClearedIsSet()) {
                attributes.add("isCleared");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            return "Cannot build ViewClosed, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ViewClosedIF {
        @Nullable
        ViewPayloadBase view;
        boolean isCleared;
        boolean isClearedIsSet;
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String callbackId;
        @Nullable
        String actionTs;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;
        @Nullable
        SlackChannel channel;

        Json() {
        }

        @JsonProperty
        public void setView(ViewPayloadBase view) {
            this.view = view;
        }

        @JsonProperty
        public void setIsCleared(boolean isCleared) {
            this.isCleared = isCleared;
            this.isClearedIsSet = true;
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @Override
        public ViewPayloadBase getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getIsCleared() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }
    }
}

