/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.ViewStateValuesPayloadIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ViewStateValuesPayload
implements ViewStateValuesPayloadIF {
    private final Map<String, Map<String, ViewInput>> blockIdToActionIdToValues;

    private ViewStateValuesPayload(Map<String, Map<String, ViewInput>> blockIdToActionIdToValues) {
        this.blockIdToActionIdToValues = blockIdToActionIdToValues;
    }

    @Override
    @JsonProperty(value="values")
    public Map<String, Map<String, ViewInput>> getBlockIdToActionIdToValues() {
        return this.blockIdToActionIdToValues;
    }

    public final ViewStateValuesPayload withBlockIdToActionIdToValues(Map<String, ? extends Map<String, ViewInput>> blockIdToActionIdToValues) {
        if (this.blockIdToActionIdToValues == blockIdToActionIdToValues) {
            return this;
        }
        Map<String, Map<String, ViewInput>> newValue = ViewStateValuesPayload.createUnmodifiableMap(true, false, blockIdToActionIdToValues);
        return new ViewStateValuesPayload(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewStateValuesPayload && this.equalTo((ViewStateValuesPayload)another);
    }

    private boolean equalTo(ViewStateValuesPayload another) {
        return this.blockIdToActionIdToValues.equals(another.blockIdToActionIdToValues);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.blockIdToActionIdToValues.hashCode();
        return h;
    }

    public String toString() {
        return "ViewStateValuesPayload{blockIdToActionIdToValues=" + this.blockIdToActionIdToValues + "}";
    }

    @Deprecated
    @JsonCreator
    static ViewStateValuesPayload fromJson(Json json) {
        Builder builder = ViewStateValuesPayload.builder();
        if (json.blockIdToActionIdToValues != null) {
            builder.putAllBlockIdToActionIdToValues(json.blockIdToActionIdToValues);
        }
        return builder.build();
    }

    public static ViewStateValuesPayload copyOf(ViewStateValuesPayloadIF instance) {
        if (instance instanceof ViewStateValuesPayload) {
            return (ViewStateValuesPayload)instance;
        }
        return ViewStateValuesPayload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private Map<String, Map<String, ViewInput>> blockIdToActionIdToValues = new LinkedHashMap<String, Map<String, ViewInput>>();

        private Builder() {
        }

        public final Builder from(ViewStateValuesPayloadIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllBlockIdToActionIdToValues(instance.getBlockIdToActionIdToValues());
            return this;
        }

        public final Builder putBlockIdToActionIdToValues(String key, Map<String, ViewInput> value) {
            this.blockIdToActionIdToValues.put(Objects.requireNonNull(key, "blockIdToActionIdToValues key"), Objects.requireNonNull(value, "blockIdToActionIdToValues value"));
            return this;
        }

        public final Builder putBlockIdToActionIdToValues(Map.Entry<String, ? extends Map<String, ViewInput>> entry) {
            String k = entry.getKey();
            Map<String, ViewInput> v = entry.getValue();
            this.blockIdToActionIdToValues.put(Objects.requireNonNull(k, "blockIdToActionIdToValues key"), Objects.requireNonNull(v, "blockIdToActionIdToValues value"));
            return this;
        }

        public final Builder setBlockIdToActionIdToValues(Map<String, ? extends Map<String, ViewInput>> blockIdToActionIdToValues) {
            this.blockIdToActionIdToValues.clear();
            return this.putAllBlockIdToActionIdToValues(blockIdToActionIdToValues);
        }

        public final Builder putAllBlockIdToActionIdToValues(Map<String, ? extends Map<String, ViewInput>> blockIdToActionIdToValues) {
            for (Map.Entry<String, ? extends Map<String, ViewInput>> entry : blockIdToActionIdToValues.entrySet()) {
                String k = entry.getKey();
                Map<String, ViewInput> v = entry.getValue();
                this.blockIdToActionIdToValues.put(Objects.requireNonNull(k, "blockIdToActionIdToValues key"), Objects.requireNonNull(v, "blockIdToActionIdToValues value"));
            }
            return this;
        }

        public ViewStateValuesPayload build() throws InvalidImmutableStateException {
            return new ViewStateValuesPayload(ViewStateValuesPayload.createUnmodifiableMap(false, false, this.blockIdToActionIdToValues));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ViewStateValuesPayloadIF {
        @Nullable
        Map<String, Map<String, ViewInput>> blockIdToActionIdToValues;

        Json() {
        }

        @JsonProperty(value="values")
        public void setBlockIdToActionIdToValues(Map<String, Map<String, ViewInput>> blockIdToActionIdToValues) {
            this.blockIdToActionIdToValues = blockIdToActionIdToValues;
        }

        @Override
        public Map<String, Map<String, ViewInput>> getBlockIdToActionIdToValues() {
            throw new UnsupportedOperationException();
        }
    }
}

