/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.ViewDatePickerIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ViewDatePicker
implements ViewDatePickerIF {
    @Nullable
    private final LocalDate selectedDate;
    private final ViewInputType type;

    private ViewDatePicker(@Nullable LocalDate selectedDate, ViewInputType type) {
        this.selectedDate = selectedDate;
        this.type = type;
    }

    @Override
    @JsonProperty
    public Optional<LocalDate> getSelectedDate() {
        return Optional.ofNullable(this.selectedDate);
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    public final ViewDatePicker withSelectedDate(@Nullable LocalDate value) {
        LocalDate newValue = value;
        if (this.selectedDate == newValue) {
            return this;
        }
        return new ViewDatePicker(newValue, this.type);
    }

    public final ViewDatePicker withSelectedDate(Optional<LocalDate> optional) {
        LocalDate value = optional.orElse(null);
        if (this.selectedDate == value) {
            return this;
        }
        return new ViewDatePicker(value, this.type);
    }

    public final ViewDatePicker withType(ViewInputType type) {
        if (this.type == type) {
            return this;
        }
        ViewInputType newValue = Objects.requireNonNull(type, "type");
        return new ViewDatePicker(this.selectedDate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewDatePicker && this.equalTo((ViewDatePicker)another);
    }

    private boolean equalTo(ViewDatePicker another) {
        return Objects.equals(this.selectedDate, another.selectedDate) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.selectedDate);
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewDatePicker{");
        if (this.selectedDate != null) {
            builder.append("selectedDate=").append(this.selectedDate);
        }
        if (builder.length() > 15) {
            builder.append(", ");
        }
        builder.append("type=").append((Object)this.type);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ViewDatePicker fromJson(Json json) {
        Builder builder = ViewDatePicker.builder();
        if (json.selectedDate != null) {
            builder.setSelectedDate(json.selectedDate);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static ViewDatePicker copyOf(ViewDatePickerIF instance) {
        if (instance instanceof ViewDatePicker) {
            return (ViewDatePicker)instance;
        }
        return ViewDatePicker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private LocalDate selectedDate;
        @Nullable
        private ViewInputType type;

        private Builder() {
        }

        public final Builder from(ViewDatePickerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ViewInput instance;
            Optional<LocalDate> selectedDateOptional;
            if (object instanceof ViewDatePickerIF && (selectedDateOptional = (instance = (ViewDatePickerIF)object).getSelectedDate()).isPresent()) {
                this.setSelectedDate(selectedDateOptional);
            }
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setSelectedDate(@Nullable LocalDate selectedDate) {
            this.selectedDate = selectedDate;
            return this;
        }

        public final Builder setSelectedDate(Optional<LocalDate> selectedDate) {
            this.selectedDate = selectedDate.orElse(null);
            return this;
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ViewDatePicker build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ViewDatePicker(this.selectedDate, this.type);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewDatePicker, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ViewDatePickerIF {
        Optional<LocalDate> selectedDate = Optional.empty();
        @Nullable
        ViewInputType type;

        Json() {
        }

        @JsonProperty
        public void setSelectedDate(Optional<LocalDate> selectedDate) {
            this.selectedDate = selectedDate;
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @Override
        public Optional<LocalDate> getSelectedDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

