/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import com.hubspot.slack.client.models.interaction.views.ViewPlainTextInputIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ViewPlainTextInput
implements ViewPlainTextInputIF {
    @Nullable
    private final String value;
    private final ViewInputType type;

    private ViewPlainTextInput(@Nullable String value, ViewInputType type) {
        this.value = value;
        this.type = type;
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    public final ViewPlainTextInput withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new ViewPlainTextInput(newValue, this.type);
    }

    public final ViewPlainTextInput withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ViewPlainTextInput(value, this.type);
    }

    public final ViewPlainTextInput withType(ViewInputType type) {
        if (this.type == type) {
            return this;
        }
        ViewInputType newValue = Objects.requireNonNull(type, "type");
        return new ViewPlainTextInput(this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewPlainTextInput && this.equalTo((ViewPlainTextInput)another);
    }

    private boolean equalTo(ViewPlainTextInput another) {
        return Objects.equals(this.value, another.value) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.value);
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewPlainTextInput{");
        if (this.value != null) {
            builder.append("value=").append(this.value);
        }
        if (builder.length() > 19) {
            builder.append(", ");
        }
        builder.append("type=").append((Object)this.type);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ViewPlainTextInput fromJson(Json json) {
        Builder builder = ViewPlainTextInput.builder();
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static ViewPlainTextInput copyOf(ViewPlainTextInputIF instance) {
        if (instance instanceof ViewPlainTextInput) {
            return (ViewPlainTextInput)instance;
        }
        return ViewPlainTextInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String value;
        @Nullable
        private ViewInputType type;

        private Builder() {
        }

        public final Builder from(ViewPlainTextInputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ViewInput instance;
            Optional<String> valueOptional;
            if (object instanceof ViewPlainTextInputIF && (valueOptional = (instance = (ViewPlainTextInputIF)object).getValue()).isPresent()) {
                this.setValue(valueOptional);
            }
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ViewPlainTextInput build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ViewPlainTextInput(this.value, this.type);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewPlainTextInput, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ViewPlainTextInputIF {
        Optional<String> value = Optional.empty();
        @Nullable
        ViewInputType type;

        Json() {
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

